/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.UserConfig;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.RuleMatch;

public class LongSentenceRuleTest {
    @Test
    public void testMatch() throws Exception {
        JLanguageTool lt = new JLanguageTool(TestTools.getDemoLanguage());
        LongSentenceRule rule = new LongSentenceRule(TestTools.getEnglishMessages(), new UserConfig(), 40);
        this.assertNoMatch(" is a rather short text.", rule, lt);
        this.assertMatch("Now this is not a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a rather that short text.", 0, 127, rule, lt);
        this.assertMatch("Now this is not a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a rather that short text", 0, 126, rule, lt);
        this.assertMatch("The sun slowly set behind the majestic mountains, casting a warm golden glow over the tranquil valley below, where a gentle breeze rustled the leaves of the trees, and the sound of a distant stream provided a soothing backdrop to the peaceful scene.", 0, 249, rule, lt);
        LongSentenceRule shortRule = new LongSentenceRule(TestTools.getEnglishMessages(), new UserConfig(), 6);
        this.assertNoMatch("This is a rather short text.", shortRule, lt);
        this.assertMatch("This is also a rather short text.", 0, 33, shortRule, lt);
        this.assertNoMatch("These ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ don't count.", shortRule, lt);
        this.assertNoMatch("one two three four five six.", shortRule, lt);
        this.assertNoMatch("one two three (four) five six.", shortRule, lt);
        this.assertMatch("one two three four five six seven.", 0, 34, shortRule, lt);
        this.assertNoMatch("Eins zwei drei vier f\u00fcnf sechs.", shortRule, lt);
        this.assertMatch("\n\n\nEins zwei drei vier f\u00fcnf sechs seven", 3, 39, shortRule, lt);
        this.assertMatch("Eins zwei drei vier f\u00fcnf sechs seven\n\n\n", 0, 36, shortRule, lt);
        this.assertMatch("\n\n\nEins zwei drei vier f\u00fcnf sechs seven\n\n\n", 3, 39, shortRule, lt);
        this.assertMatch("\n\n\nEins zwei drei vier f\u00fcnf sechs seven.", 3, 40, shortRule, lt);
        this.assertMatch("Eins zwei drei vier f\u00fcnf sechs seven.\n\n\n", 0, 37, shortRule, lt);
        this.assertMatch("\n\n\nEins zwei drei vier f\u00fcnf sechs seven.\n\n\n", 3, 40, shortRule, lt);
    }

    protected void assertNoMatch(String input, LongSentenceRule rule, JLanguageTool lt) throws IOException {
        MatcherAssert.assertThat((Object)rule.match(lt.analyzeText(input)).length, (Matcher)CoreMatchers.is((Object)0));
    }

    protected void assertMatch(String input, int from, int to, LongSentenceRule rule, JLanguageTool lt) throws IOException {
        RuleMatch[] matches = rule.match(lt.analyzeText(input));
        MatcherAssert.assertThat((Object)matches.length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)matches[0].getFromPos(), (Matcher)CoreMatchers.is((Object)from));
        MatcherAssert.assertThat((Object)matches[0].getToPos(), (Matcher)CoreMatchers.is((Object)to));
    }
}

