/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action;

import java.util.Objects;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;

public abstract class ActionRequestBuilder<Request extends ActionRequest, Response extends ActionResponse> {
    protected final ActionType<Response> action;
    protected final Request request;
    protected final OpenSearchClient client;

    protected ActionRequestBuilder(OpenSearchClient client, ActionType<Response> action, Request request) {
        Objects.requireNonNull(action, "action must not be null");
        this.action = action;
        this.request = request;
        this.client = client;
    }

    public Request request() {
        return this.request;
    }

    public ActionFuture<Response> execute() {
        return this.client.execute(this.action, this.request);
    }

    public Response get() {
        return (Response)((ActionResponse)this.execute().actionGet());
    }

    public Response get(TimeValue timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public Response get(String timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public void execute(ActionListener<Response> listener) {
        this.client.execute(this.action, this.request, listener);
    }
}

