/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

final class Lucene90NormsConsumer
extends NormsConsumer {
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene90NormsConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeIndexHeader(this.data, dataCodec, 0, state.segmentInfo.getId(), state.segmentSuffix);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeIndexHeader(this.meta, metaCodec, 0, state.segmentInfo.getId(), state.segmentSuffix);
            this.maxDoc = state.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }

    @Override
    public void addNormsField(FieldInfo field, NormsProducer normsProducer) throws IOException {
        NumericDocValues values = normsProducer.getNorms(field);
        int numDocsWithValue = 0;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithValue;
            long v = values.longValue();
            min = Math.min(min, v);
            max = Math.max(max, v);
            doc = values.nextDoc();
        }
        assert (numDocsWithValue <= this.maxDoc);
        this.meta.writeInt(field.number);
        if (numDocsWithValue == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else if (numDocsWithValue == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values = normsProducer.getNorms(field);
            short jumpTableEntryCount = IndexedDISI.writeBitSet(values, this.data, (byte)9);
            this.meta.writeLong(this.data.getFilePointer() - offset);
            this.meta.writeShort(jumpTableEntryCount);
            this.meta.writeByte((byte)9);
        }
        this.meta.writeInt(numDocsWithValue);
        int numBytesPerValue = this.numBytesPerValue(min, max);
        this.meta.writeByte((byte)numBytesPerValue);
        if (numBytesPerValue == 0) {
            this.meta.writeLong(min);
        } else {
            this.meta.writeLong(this.data.getFilePointer());
            values = normsProducer.getNorms(field);
            this.writeValues(values, numBytesPerValue, this.data);
        }
    }

    private int numBytesPerValue(long min, long max) {
        if (min >= max) {
            return 0;
        }
        if (min >= -128L && max <= 127L) {
            return 1;
        }
        if (min >= -32768L && max <= 32767L) {
            return 2;
        }
        if (min >= Integer.MIN_VALUE && max <= Integer.MAX_VALUE) {
            return 4;
        }
        return 8;
    }

    private void writeValues(NumericDocValues values, int numBytesPerValue, IndexOutput out) throws IOException, AssertionError {
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            long value = values.longValue();
            switch (numBytesPerValue) {
                case 1: {
                    out.writeByte((byte)value);
                    break;
                }
                case 2: {
                    out.writeShort((short)value);
                    break;
                }
                case 4: {
                    out.writeInt((int)value);
                    break;
                }
                case 8: {
                    out.writeLong(value);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            doc = values.nextDoc();
        }
    }
}

