/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.tasks.resourcetracker;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.tasks.resourcetracker.TaskResourceUsage;
import org.opensearch.core.tasks.resourcetracker.TaskThreadUsage;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class TaskResourceStats
implements Writeable,
ToXContentFragment {
    private final Map<String, TaskResourceUsage> resourceUsage;
    private final TaskThreadUsage threadUsage;
    public static final String THREAD_INFO = "thread_info";

    public TaskResourceStats(Map<String, TaskResourceUsage> resourceUsage, TaskThreadUsage threadUsage) {
        this.resourceUsage = Objects.requireNonNull(resourceUsage, "resource usage is required");
        this.threadUsage = Objects.requireNonNull(threadUsage, "thread usage is required");
    }

    public TaskResourceStats(StreamInput in) throws IOException {
        this.resourceUsage = in.readMap(StreamInput::readString, TaskResourceUsage::readFromStream);
        this.threadUsage = in.getVersion().onOrAfter(Version.V_2_9_0) ? TaskThreadUsage.readFromStream(in) : new TaskThreadUsage(0, 0);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.resourceUsage, StreamOutput::writeString, (stream, stats) -> stats.writeTo(stream));
        if (out.getVersion().onOrAfter(Version.V_2_9_0)) {
            this.threadUsage.writeTo(out);
        }
    }

    public Map<String, TaskResourceUsage> getResourceUsageInfo() {
        return this.resourceUsage;
    }

    public TaskThreadUsage getThreadUsage() {
        return this.threadUsage;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, TaskResourceUsage> resourceUsageEntry : this.resourceUsage.entrySet()) {
            builder.startObject(resourceUsageEntry.getKey());
            if (resourceUsageEntry.getValue() != null) {
                resourceUsageEntry.getValue().toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.startObject(THREAD_INFO);
        this.threadUsage.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static TaskResourceStats fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        HashMap<String, TaskResourceUsage> resourceStats = new HashMap<String, TaskResourceUsage>();
        TaskThreadUsage threadUsage = new TaskThreadUsage(0, 0);
        if (token == XContentParser.Token.FIELD_NAME) {
            assert (parser.currentToken() == XContentParser.Token.FIELD_NAME) : "Expected field name but saw [" + parser.currentToken() + "]";
            do {
                String fieldName;
                if ((fieldName = parser.currentName()).equals(THREAD_INFO)) {
                    threadUsage = TaskThreadUsage.fromXContent(parser);
                    continue;
                }
                TaskResourceUsage value = TaskResourceUsage.fromXContent(parser);
                resourceStats.put(fieldName, value);
            } while (parser.nextToken() == XContentParser.Token.FIELD_NAME);
        }
        return new TaskResourceStats(resourceStats, threadUsage);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != TaskResourceStats.class) {
            return false;
        }
        TaskResourceStats other = (TaskResourceStats)obj;
        return Objects.equals(this.resourceUsage, other.resourceUsage);
    }

    public int hashCode() {
        return Objects.hash(this.resourceUsage);
    }
}

