/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;

public class ParentChildrenBlockJoinQuery
extends Query {
    private final BitSetProducer parentFilter;
    private final Query childQuery;
    private final int parentDocId;

    public ParentChildrenBlockJoinQuery(BitSetProducer parentFilter, Query childQuery, int parentDocId) {
        this.parentFilter = parentFilter;
        this.childQuery = childQuery;
        this.parentDocId = parentDocId;
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        ParentChildrenBlockJoinQuery other = (ParentChildrenBlockJoinQuery)((Object)obj);
        return this.parentFilter.equals(other.parentFilter) && this.childQuery.equals((Object)other.childQuery) && this.parentDocId == other.parentDocId;
    }

    public int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.parentFilter.hashCode();
        hash = 31 * hash + this.childQuery.hashCode();
        hash = 31 * hash + this.parentDocId;
        return hash;
    }

    public String toString(String field) {
        return "ParentChildrenBlockJoinQuery (" + this.childQuery + ")";
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query childRewrite = this.childQuery.rewrite(indexSearcher);
        if (childRewrite != this.childQuery) {
            return new ParentChildrenBlockJoinQuery(this.parentFilter, childRewrite, this.parentDocId);
        }
        return super.rewrite(indexSearcher);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        final Weight childWeight = this.childQuery.createWeight(searcher, scoreMode, boost);
        final int readerIndex = ReaderUtil.subIndex((int)this.parentDocId, (List)searcher.getIndexReader().leaves());
        return new Weight(this){

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return Explanation.noMatch((String)"Not implemented, use ToParentBlockJoinQuery explain why a document matched", (Explanation[])new Explanation[0]);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                if (context.ord != readerIndex) {
                    return null;
                }
                final int localParentDocId = ParentChildrenBlockJoinQuery.this.parentDocId - context.docBase;
                if (localParentDocId == 0) {
                    return null;
                }
                BitSet parents = ParentChildrenBlockJoinQuery.this.parentFilter.getBitSet(context);
                final int firstChildDocId = parents.prevSetBit(localParentDocId - 1) + 1;
                if (firstChildDocId == localParentDocId) {
                    return null;
                }
                final Scorer childrenScorer = childWeight.scorer(context);
                if (childrenScorer == null) {
                    return null;
                }
                final DocIdSetIterator childrenIterator = childrenScorer.iterator();
                final DocIdSetIterator it = new DocIdSetIterator(){
                    int doc = -1;

                    public int docID() {
                        return this.doc;
                    }

                    public int nextDoc() throws IOException {
                        return this.advance(this.doc + 1);
                    }

                    public int advance(int target) throws IOException {
                        if ((target = Math.max(firstChildDocId, target)) >= localParentDocId) {
                            this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }
                        int advanced = childrenIterator.advance(target);
                        if (advanced >= localParentDocId) {
                            this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }
                        this.doc = advanced;
                        return this.doc;
                    }

                    public long cost() {
                        return Math.min(childrenIterator.cost(), (long)(localParentDocId - firstChildDocId));
                    }
                };
                return new Scorer(this){

                    public int docID() {
                        return it.docID();
                    }

                    public float score() throws IOException {
                        return childrenScorer.score();
                    }

                    public float getMaxScore(int upTo) throws IOException {
                        return Float.POSITIVE_INFINITY;
                    }

                    public DocIdSetIterator iterator() {
                        return it;
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }
}

