/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport.handler;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.transport.ADResultBulkAction;
import org.opensearch.ad.transport.ADResultBulkRequest;
import org.opensearch.ad.transport.ADResultBulkResponse;
import org.opensearch.ad.transport.handler.AnomalyIndexHandler;
import org.opensearch.ad.util.ClientUtil;
import org.opensearch.ad.util.IndexUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;

public class MultiEntityResultHandler
extends AnomalyIndexHandler<AnomalyResult> {
    private static final Logger LOG = LogManager.getLogger(MultiEntityResultHandler.class);
    static final String SUCCESS_SAVING_RESULT_MSG = "Result saved successfully.";
    static final String CANNOT_SAVE_RESULT_ERR_MSG = "Cannot save results due to write block.";

    @Inject
    public MultiEntityResultHandler(Client client, Settings settings, ThreadPool threadPool, AnomalyDetectionIndices anomalyDetectionIndices, ClientUtil clientUtil, IndexUtils indexUtils, ClusterService clusterService) {
        super(client, settings, threadPool, ".opendistro-anomaly-results", anomalyDetectionIndices, clientUtil, indexUtils, clusterService);
    }

    public void flush(ADResultBulkRequest currentBulkRequest, ActionListener<ADResultBulkResponse> listener) {
        if (this.indexUtils.checkIndicesBlocked(this.clusterService.state(), ClusterBlockLevel.WRITE, this.indexName)) {
            listener.onFailure((Exception)new AnomalyDetectionException(CANNOT_SAVE_RESULT_ERR_MSG));
            return;
        }
        try {
            if (!this.anomalyDetectionIndices.doesDefaultAnomalyResultIndexExist()) {
                this.anomalyDetectionIndices.initDefaultAnomalyResultIndexDirectly((ActionListener<CreateIndexResponse>)ActionListener.wrap(initResponse -> {
                    if (initResponse.isAcknowledged()) {
                        this.bulk(currentBulkRequest, listener);
                    } else {
                        LOG.warn("Creating result index with mappings call not acknowledged.");
                        listener.onFailure((Exception)new AnomalyDetectionException("", "Creating result index with mappings call not acknowledged."));
                    }
                }, exception -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                        this.bulk(currentBulkRequest, listener);
                    } else {
                        LOG.warn("Unexpected error creating result index", (Throwable)exception);
                        listener.onFailure(exception);
                    }
                }));
            } else {
                this.bulk(currentBulkRequest, listener);
            }
        }
        catch (Exception e) {
            LOG.warn("Error in bulking results", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void bulk(ADResultBulkRequest currentBulkRequest, ActionListener<ADResultBulkResponse> listener) {
        if (currentBulkRequest.numberOfActions() <= 0) {
            listener.onFailure((Exception)new AnomalyDetectionException("no result to save"));
            return;
        }
        this.client.execute((ActionType)ADResultBulkAction.INSTANCE, (ActionRequest)currentBulkRequest, ActionListener.wrap(response -> {
            LOG.debug(SUCCESS_SAVING_RESULT_MSG);
            listener.onResponse((Object)response);
        }, exception -> {
            LOG.error("Error in bulking results", (Throwable)exception);
            listener.onFailure(exception);
        }));
    }
}

