"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiPopoverTitle", {
  enumerable: true,
  get: function get() {
    return _popover_title.EuiPopoverTitle;
  }
});
exports.OuiPopoverTitle = exports.PADDING_SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

var _popover_title = require("../../eui_components/popover/popover_title");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var paddingSizeToClassNameMap = {
  none: 'ouiPopoverTitle--paddingNone',
  s: 'ouiPopoverTitle--paddingSmall',
  m: 'ouiPopoverTitle--paddingMedium',
  l: 'ouiPopoverTitle--paddingLarge'
};
var PADDING_SIZES = (0, _common.keysOf)(paddingSizeToClassNameMap);
exports.PADDING_SIZES = PADDING_SIZES;

var OuiPopoverTitle = function OuiPopoverTitle(_ref) {
  var children = _ref.children,
      className = _ref.className,
      paddingSize = _ref.paddingSize,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "paddingSize"]);
  var classes = (0, _classnames.default)('ouiPopoverTitle', paddingSize ? paddingSizeToClassNameMap[paddingSize] : null, className);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), children);
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiPopoverTitle = OuiPopoverTitle;
OuiPopoverTitle.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
         * Customize the all around padding of the popover title.
         * Leave `undefined` to inherit from the `panelPaddingSize` of the containing OuiPopover
         */
  paddingSize: _propTypes.default.any
};