'use strict';

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var isNil = require('lodash.isnil');

var ValuesSourceBase = require('./values-source-base');

var REF_URL = 'https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-bucket-composite-aggregation.html#_date_histogram';

/**
 * `DateHistogramValuesSource` is a source for the `CompositeAggregation` that
 * handles date histograms. It works very similar to a histogram aggregation
 * with a slightly different syntax.
 *
 * [Elasticsearch reference](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-bucket-composite-aggregation.html#_date_histogram)
 *
 * @example
 * const valueSrc = esb.CompositeAggregation.dateHistogramValuesSource(
 *   'date', // name
 *   'timestamp', // field
 *   '1d' // interval
 * );
 *
 * @param {string} name
 * @param {string=} field The field to aggregate on
 * @param {string|number=} interval Interval to generate histogram over.
 *
 * @extends ValuesSourceBase
 */

var DateHistogramValuesSource = function (_ValuesSourceBase) {
    (0, _inherits3.default)(DateHistogramValuesSource, _ValuesSourceBase);

    // eslint-disable-next-line require-jsdoc
    function DateHistogramValuesSource(name, field, interval) {
        (0, _classCallCheck3.default)(this, DateHistogramValuesSource);

        var _this = (0, _possibleConstructorReturn3.default)(this, (DateHistogramValuesSource.__proto__ || Object.getPrototypeOf(DateHistogramValuesSource)).call(this, 'date_histogram', REF_URL, name, field));

        if (!isNil(interval)) _this._opts.interval = interval;
        return _this;
    }

    /**
     * Sets the histogram interval. Buckets are generated based on this interval value.
     *
     * @param {string|number} interval Interval to generate histogram over.
     * @returns {DateHistogramValuesSource} returns `this` so that calls can be chained
     */


    (0, _createClass3.default)(DateHistogramValuesSource, [{
        key: 'interval',
        value: function interval(_interval) {
            this._opts.interval = _interval;
            return this;
        }

        /**
         * Sets the date time zone
         *
         * Date-times are stored in Elasticsearch in UTC. By default, all bucketing
         * and rounding is also done in UTC. The `time_zone` parameter can be used
         * to indicate that bucketing should use a different time zone.
         *
         * @param {string} tz Time zone. Time zones may either be specified
         * as an ISO 8601 UTC offset (e.g. +01:00 or -08:00) or as a timezone id,
         * an identifier used in the TZ database like America/Los_Angeles.
         * @returns {DateHistogramValuesSource} returns `this` so that calls can be chained
         */

    }, {
        key: 'timeZone',
        value: function timeZone(tz) {
            this._opts.time_zone = tz;
            return this;
        }

        /**
         * Sets the format expression for `key_as_string` in response buckets.
         * If no format is specified, then it will use the first format specified
         * in the field mapping.
         *
         * @example
         * const valueSrc = esb.CompositeAggregation.valuesSource
         *   .dateHistogram('date', 'timestamp', '1d')
         *   .format('yyyy-MM-dd');
         *
         * @param {string} fmt Format mask to apply on aggregation response.
         * For Date Histograms, supports expressive [date format pattern](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-bucket-daterange-aggregation.html#date-format-pattern)
         * @returns {DateHistogramValuesSource} returns `this` so that calls can be chained
         */

    }, {
        key: 'format',
        value: function format(fmt) {
            this._opts.format = fmt;
            return this;
        }
    }]);
    return DateHistogramValuesSource;
}(ValuesSourceBase);

module.exports = DateHistogramValuesSource;