/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.action;

import java.io.IOException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.geospatial.exceptions.ConcurrentModificationException;
import org.opensearch.geospatial.exceptions.IncompatibleDatasourceException;
import org.opensearch.geospatial.ip2geo.action.UpdateDatasourceRequest;
import org.opensearch.geospatial.ip2geo.common.DatasourceManifest;
import org.opensearch.geospatial.ip2geo.common.DatasourceState;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoLockService;
import org.opensearch.geospatial.ip2geo.dao.DatasourceDao;
import org.opensearch.geospatial.ip2geo.jobscheduler.Datasource;
import org.opensearch.geospatial.ip2geo.jobscheduler.DatasourceTask;
import org.opensearch.geospatial.ip2geo.jobscheduler.DatasourceUpdateService;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class UpdateDatasourceTransportAction
extends HandledTransportAction<UpdateDatasourceRequest, AcknowledgedResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateDatasourceTransportAction.class);
    private static final long LOCK_DURATION_IN_SECONDS = 300L;
    private final Ip2GeoLockService lockService;
    private final DatasourceDao datasourceDao;
    private final DatasourceUpdateService datasourceUpdateService;
    private final ThreadPool threadPool;

    @Inject
    public UpdateDatasourceTransportAction(TransportService transportService, ActionFilters actionFilters, Ip2GeoLockService lockService, DatasourceDao datasourceDao, DatasourceUpdateService datasourceUpdateService, ThreadPool threadPool) {
        super("cluster:admin/geospatial/datasource/update", transportService, actionFilters, UpdateDatasourceRequest::new);
        this.lockService = lockService;
        this.datasourceUpdateService = datasourceUpdateService;
        this.datasourceDao = datasourceDao;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, UpdateDatasourceRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.lockService.acquireLock(request.getName(), 300L, (ActionListener<LockModel>)ActionListener.wrap(lock -> {
            if (lock == null) {
                listener.onFailure((Exception)((Object)new ConcurrentModificationException("another processor is holding a lock on the resource. Try again later", new Object[0])));
                return;
            }
            try {
                this.threadPool.generic().submit(() -> {
                    try {
                        Datasource datasource = this.datasourceDao.getDatasource(request.getName());
                        if (datasource == null) {
                            throw new ResourceNotFoundException("no such datasource exist", new Object[0]);
                        }
                        if (!DatasourceState.AVAILABLE.equals((Object)datasource.getState())) {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "data source is not in an [%s] state", new Object[]{DatasourceState.AVAILABLE}));
                        }
                        this.validate(request, datasource);
                        this.updateIfChanged(request, datasource);
                        this.lockService.releaseLock((LockModel)lock);
                        listener.onResponse((Object)new AcknowledgedResponse(true));
                    }
                    catch (Exception e) {
                        this.lockService.releaseLock((LockModel)lock);
                        listener.onFailure(e);
                    }
                });
            }
            catch (Exception e) {
                this.lockService.releaseLock((LockModel)lock);
                listener.onFailure(e);
            }
        }, exception -> listener.onFailure(exception)));
    }

    private void updateIfChanged(UpdateDatasourceRequest request, Datasource datasource) {
        boolean isChanged = false;
        if (this.isEndpointChanged(request, datasource)) {
            datasource.setEndpoint(request.getEndpoint());
            isChanged = true;
        }
        if (this.isUpdateIntervalChanged(request)) {
            datasource.setUserSchedule(new IntervalSchedule(Instant.now(), (int)request.getUpdateInterval().getDays(), ChronoUnit.DAYS));
            datasource.setSystemSchedule(datasource.getUserSchedule());
            datasource.setTask(DatasourceTask.ALL);
            isChanged = true;
        }
        if (isChanged) {
            this.datasourceDao.updateDatasource(datasource);
        }
    }

    private void validate(UpdateDatasourceRequest request, Datasource datasource) throws IOException {
        this.validateFieldsCompatibility(request, datasource);
        this.validateUpdateIntervalIsLessThanValidForInDays(request, datasource);
        this.validateNextUpdateScheduleIsBeforeExpirationDay(request, datasource);
    }

    private void validateNextUpdateScheduleIsBeforeExpirationDay(UpdateDatasourceRequest request, Datasource datasource) {
        if (request.getUpdateInterval() == null) {
            return;
        }
        IntervalSchedule newSchedule = new IntervalSchedule(Instant.now(), (int)request.getUpdateInterval().getDays(), ChronoUnit.DAYS);
        if (newSchedule.getNextExecutionTime(Instant.now()).isAfter(datasource.expirationDay())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "datasource will expire at %s with the update interval", datasource.expirationDay().toString()));
        }
    }

    private void validateFieldsCompatibility(UpdateDatasourceRequest request, Datasource datasource) throws IOException {
        if (!this.isEndpointChanged(request, datasource)) {
            return;
        }
        List<String> fields = this.datasourceUpdateService.getHeaderFields(request.getEndpoint());
        if (!datasource.isCompatible(fields)) {
            throw new IncompatibleDatasourceException("new fields [{}] does not contain all old fields [{}]", fields.toString(), datasource.getDatabase().getFields().toString());
        }
    }

    private void validateUpdateIntervalIsLessThanValidForInDays(UpdateDatasourceRequest request, Datasource datasource) throws IOException {
        long updateInterval;
        if (!this.isEndpointChanged(request, datasource) && !this.isUpdateIntervalChanged(request)) {
            return;
        }
        long validForInDays = this.isEndpointChanged(request, datasource) ? DatasourceManifest.Builder.build(new URL(request.getEndpoint())).getValidForInDays() : datasource.getDatabase().getValidForInDays();
        long l = updateInterval = this.isUpdateIntervalChanged(request) ? request.getUpdateInterval().days() : (long)datasource.getUserSchedule().getInterval();
        if (updateInterval >= validForInDays) {
            throw new InvalidParameterException(String.format(Locale.ROOT, "updateInterval %d should be smaller than %d", updateInterval, validForInDays));
        }
    }

    private boolean isEndpointChanged(UpdateDatasourceRequest request, Datasource datasource) {
        return request.getEndpoint() != null && !request.getEndpoint().equals(datasource.getEndpoint());
    }

    private boolean isUpdateIntervalChanged(UpdateDatasourceRequest request) {
        return request.getUpdateInterval() != null;
    }
}

