/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN9120Codec;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.IOUtils;
import org.opensearch.index.fieldvisitor.FieldsVisitor;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReaders;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceStoredFieldVisitor;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceVectorInjector;

public class DerivedSourceStoredFieldsReader
extends StoredFieldsReader {
    @Generated
    private static final Logger log = LogManager.getLogger(DerivedSourceStoredFieldsReader.class);
    private final StoredFieldsReader delegate;
    private final List<FieldInfo> derivedVectorFields;
    private final DerivedSourceReaders derivedSourceReaders;
    private final SegmentReadState segmentReadState;
    private final boolean shouldInject;
    private final DerivedSourceVectorInjector derivedSourceVectorInjector;

    public DerivedSourceStoredFieldsReader(StoredFieldsReader delegate, List<FieldInfo> derivedVectorFields, DerivedSourceReaders derivedSourceReaders, SegmentReadState segmentReadState) throws IOException {
        this(delegate, derivedVectorFields, derivedSourceReaders, segmentReadState, true);
    }

    private DerivedSourceStoredFieldsReader(StoredFieldsReader delegate, List<FieldInfo> derivedVectorFields, DerivedSourceReaders derivedSourceReaders, SegmentReadState segmentReadState, boolean shouldInject) throws IOException {
        this.delegate = delegate;
        this.derivedVectorFields = derivedVectorFields;
        this.derivedSourceReaders = derivedSourceReaders;
        this.segmentReadState = segmentReadState;
        this.shouldInject = shouldInject;
        this.derivedSourceVectorInjector = this.createDerivedSourceVectorInjector();
    }

    private DerivedSourceVectorInjector createDerivedSourceVectorInjector() {
        return new DerivedSourceVectorInjector(this.derivedSourceReaders, this.segmentReadState, this.derivedVectorFields);
    }

    public void document(int docId, StoredFieldVisitor storedFieldVisitor) throws IOException {
        boolean isVisitorNeedFields = true;
        if (storedFieldVisitor instanceof FieldsVisitor) {
            isVisitorNeedFields = this.derivedSourceVectorInjector.shouldInject(((FieldsVisitor)storedFieldVisitor).includes(), ((FieldsVisitor)storedFieldVisitor).excludes());
        }
        if (this.shouldInject && isVisitorNeedFields) {
            this.delegate.document(docId, (StoredFieldVisitor)new DerivedSourceStoredFieldVisitor(storedFieldVisitor, docId, this.derivedSourceVectorInjector));
            return;
        }
        this.delegate.document(docId, storedFieldVisitor);
    }

    public StoredFieldsReader clone() {
        try {
            return new DerivedSourceStoredFieldsReader(this.delegate.clone(), this.derivedVectorFields, this.derivedSourceReaders.clone(), this.segmentReadState, this.shouldInject);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkIntegrity() throws IOException {
        this.delegate.checkIntegrity();
    }

    public void close() throws IOException {
        log.debug("Closing derived source stored fields reader for segment: " + this.segmentReadState.segmentInfo.name);
        IOUtils.close((Closeable[])new Closeable[]{this.delegate, this.derivedSourceVectorInjector});
    }

    private StoredFieldsReader cloneForMerge() {
        try {
            return new DerivedSourceStoredFieldsReader(this.delegate.getMergeInstance(), this.derivedVectorFields, this.derivedSourceReaders.clone(), this.segmentReadState, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static StoredFieldsReader wrapForMerge(StoredFieldsReader storedFieldsReader) {
        if (storedFieldsReader instanceof DerivedSourceStoredFieldsReader) {
            return ((DerivedSourceStoredFieldsReader)storedFieldsReader).cloneForMerge();
        }
        return storedFieldsReader;
    }
}

