/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.commons.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatsType;

public enum RcaGraphMetrics implements MeasurementSet
{
    GRAPH_EXECUTION_TIME("RcaGraphExecution", "millis", StatsType.LATENCIES, Arrays.asList(Statistics.MAX, Statistics.MEAN, Statistics.SUM)),
    GRAPH_NODE_OPERATE_CALL("OperateCall", "millis", StatsType.LATENCIES, Arrays.asList(Statistics.MAX, Statistics.MEAN, Statistics.SUM)),
    METRIC_GATHER_CALL("MetricGatherCall", "millis", StatsType.LATENCIES, Arrays.asList(Statistics.MAX, Statistics.MEAN, Statistics.SUM)),
    NUM_GRAPH_NODES("NumGraphNodes"),
    NUM_GRAPH_NODES_MUTED("NumOfMutedGraphNodes"),
    NUM_NODES_EXECUTED_LOCALLY("NodesExecutedLocally"),
    NUM_NODES_EXECUTED_REMOTELY("NodesExecutedRemotely"),
    NET_BYTES_OUT("TotalRcaBytesOutSerialized", "bytes", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS)),
    NET_BYTES_IN("TotalRcaBytesInSerialized", "bytes", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS)),
    RCA_RX_EMPTY_FU("RcaReceivedEmptyFU", "namedCount", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS)),
    RCA_NETWORK_ERROR("RcaNetworkError", "namedCount", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS)),
    RCA_PERSIST_CALL("RcaPersistCall", "millis", StatsType.LATENCIES, Arrays.asList(Statistics.MAX, Statistics.MEAN, Statistics.SUM)),
    RCA_NODES_FU_PUBLISH_COUNT("RcaFlowUnitPublishCount", "namedCount", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS)),
    RCA_NODES_FU_CONSUME_COUNT("RcaFlowUnitConsumeCount", "namedCount", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS)),
    RCA_NODES_SUB_REQ_COUNT("RcaSubscriptionRequestCount", "namedCount", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS)),
    RCA_NODES_SUB_ACK_COUNT("RcaSubscriptionAckCount", "namedCount", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS));

    private String name;
    private String unit;
    private StatsType statsType;
    private List<Statistics> statsList;

    private RcaGraphMetrics(String name) {
        this(name, "count", StatsType.STATS_DATA, Collections.singletonList(Statistics.COUNT));
    }

    private RcaGraphMetrics(String name, String unit, StatsType statsType, List<Statistics> statisticList) {
        this.name = name;
        this.unit = unit;
        this.statsType = statsType;
        this.statsList = statisticList;
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    public StatsType getStatsType() {
        return this.statsType;
    }

    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }
}

