/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.metrics;

import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.commons.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatsType;

public enum RcaRuntimeMetrics implements MeasurementSet
{
    RCA_SCHEDULER_RESTART("RcaSchedulerRestart"),
    RCA_STOPPED_BY_OPERATOR("RcaStoppedByOperator"),
    RCA_RESTARTED_BY_OPERATOR("RcaRestartedByOperator"),
    OPEN_SEARCH_APIS_CALLED("OpenSearchApisCalled", "namedCount", StatsType.STATS_DATA, Statistics.NAMED_COUNTERS),
    RCA_ENABLED("RcaEnabled", "count", StatsType.STATS_DATA, Statistics.SAMPLE),
    NO_INCREASE_ACTION_SUGGESTED("NoIncreaseAction", "namedCount", StatsType.STATS_DATA, Statistics.NAMED_COUNTERS),
    HEAP_SIZE_INCREASE_ACTION_SUGGESTED("HeapSizeIncreaseAction"),
    ACTIONS_PUBLISHED("ActionsPublished", "namedCount", StatsType.STATS_DATA, Statistics.NAMED_COUNTERS),
    BLOCKED_TRANSPORT_THREAD_COUNT("BlockedTransportThreadCount", "count", StatsType.STATS_DATA, Statistics.MAX),
    WAITED_TRANSPORT_THREAD_COUNT("WaitedTransportThreadCount", "count", StatsType.STATS_DATA, Statistics.MAX),
    MAX_TRANSPORT_THREAD_BLOCKED_TIME("MaxTransportThreadBlockedTime", "seconds", StatsType.LATENCIES, Statistics.MAX),
    MAX_TRANSPORT_THREAD_WAITED_TIME("MaxTransportThreadWaitedTime", "seconds", StatsType.LATENCIES, Statistics.MAX);

    private String name;
    private String unit;
    private StatsType statsType;
    private List<Statistics> statsList;

    private RcaRuntimeMetrics(String name) {
        this(name, "count", StatsType.STATS_DATA, Collections.singletonList(Statistics.COUNT));
    }

    private RcaRuntimeMetrics(String name, String unit, StatsType statsType, Statistics stats) {
        this(name, unit, statsType, Collections.singletonList(stats));
    }

    private RcaRuntimeMetrics(String name, String unit, StatsType statsType, List<Statistics> statisticList) {
        this.name = name;
        this.unit = unit;
        this.statsType = statsType;
        this.statsList = statisticList;
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    public StatsType getStatsType() {
        return this.statsType;
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }
}

