/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.collector;

import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.grpc.Resource;
import org.opensearch.performanceanalyzer.rca.framework.api.OpenSearchConfigNode;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.NodeConfigFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.Cache_Max_Size;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.Heap_Max;
import org.opensearch.performanceanalyzer.rca.framework.api.metrics.ThreadPool_QueueCapacity;
import org.opensearch.performanceanalyzer.rca.framework.api.persist.SQLParsingUtil;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import org.opensearch.performanceanalyzer.rca.store.collector.NodeConfigCache;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class NodeConfigCollector
extends OpenSearchConfigNode {
    private static final Logger LOG = LogManager.getLogger(NodeConfigCollector.class);
    private final ThreadPool_QueueCapacity threadPool_queueCapacity;
    private final Cache_Max_Size cacheMaxSize;
    private final Heap_Max heapMaxSize;
    private final int rcaPeriod;
    private int counter;
    private final HashMap<Resource, Double> configResult;

    public NodeConfigCollector(int rcaPeriod, ThreadPool_QueueCapacity threadPool_queueCapacity, Cache_Max_Size cacheMaxSize, Heap_Max heapMaxSize) {
        this.threadPool_queueCapacity = threadPool_queueCapacity;
        this.cacheMaxSize = cacheMaxSize;
        this.heapMaxSize = heapMaxSize;
        this.rcaPeriod = rcaPeriod;
        this.counter = 0;
        this.configResult = new HashMap();
    }

    private void collectQueueCapacity(MetricFlowUnit flowUnit) {
        double writeQueueCapacity = SQLParsingUtil.readDataFromSqlResult(flowUnit.getData(), (Field<String>)AllMetrics.ThreadPoolDimension.THREAD_POOL_TYPE.getField(), AllMetrics.ThreadPoolType.WRITE.toString(), "max");
        this.collectAndPublishMetric(ResourceUtil.WRITE_QUEUE_CAPACITY, writeQueueCapacity);
        double searchQueueCapacity = SQLParsingUtil.readDataFromSqlResult(flowUnit.getData(), (Field<String>)AllMetrics.ThreadPoolDimension.THREAD_POOL_TYPE.getField(), AllMetrics.ThreadPoolType.SEARCH.toString(), "max");
        this.collectAndPublishMetric(ResourceUtil.SEARCH_QUEUE_CAPACITY, searchQueueCapacity);
    }

    private void collectCacheMaxSize(MetricFlowUnit cacheMaxSize) {
        double fieldDataCacheMaxSize = SQLParsingUtil.readDataFromSqlResult(cacheMaxSize.getData(), (Field<String>)AllMetrics.CacheConfigDimension.CACHE_TYPE.getField(), AllMetrics.CacheType.FIELD_DATA_CACHE.toString(), "max");
        this.collectAndPublishMetric(ResourceUtil.FIELD_DATA_CACHE_MAX_SIZE, fieldDataCacheMaxSize);
        double shardRequestCacheMaxSize = SQLParsingUtil.readDataFromSqlResult(cacheMaxSize.getData(), (Field<String>)AllMetrics.CacheConfigDimension.CACHE_TYPE.getField(), AllMetrics.CacheType.SHARD_REQUEST_CACHE.toString(), "max");
        this.collectAndPublishMetric(ResourceUtil.SHARD_REQUEST_CACHE_MAX_SIZE, shardRequestCacheMaxSize);
    }

    private void collectHeapStats(MetricFlowUnit heapMax) {
        double heapMaxSize = SQLParsingUtil.readDataFromSqlResult(heapMax.getData(), (Field<String>)AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.HEAP.toString(), "max");
        this.collectAndPublishMetric(ResourceUtil.HEAP_MAX_SIZE, heapMaxSize);
        double oldGenMaxSize = SQLParsingUtil.readDataFromSqlResult(heapMax.getData(), (Field<String>)AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.OLD_GEN.toString(), "max");
        this.collectAndPublishMetric(ResourceUtil.OLD_GEN_MAX_SIZE, oldGenMaxSize);
        double edenMaxSize = SQLParsingUtil.readDataFromSqlResult(heapMax.getData(), (Field<String>)AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.EDEN.toString(), "max");
        double survivorMaxSize = SQLParsingUtil.readDataFromSqlResult(heapMax.getData(), (Field<String>)AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.SURVIVOR.toString(), "max");
        this.collectAndPublishMetric(ResourceUtil.YOUNG_GEN_MAX_SIZE, edenMaxSize + 2.0 * survivorMaxSize);
    }

    private void collectAndPublishMetric(Resource resource, double metricValue) {
        if (!Double.isNaN(metricValue)) {
            NodeConfigCache nodeConfigCache = this.getAppContext().getNodeConfigCache();
            NodeKey nodeKey = new NodeKey(this.getAppContext().getMyInstanceDetails());
            this.configResult.put(resource, metricValue);
            nodeConfigCache.put(nodeKey, resource, metricValue);
        } else {
            LOG.error("Metric value is NaN for resource:" + resource.toString());
        }
    }

    @Override
    public NodeConfigFlowUnit operate() {
        ++this.counter;
        for (MetricFlowUnit flowUnit : this.threadPool_queueCapacity.getFlowUnits()) {
            if (flowUnit.isEmpty()) continue;
            this.collectQueueCapacity(flowUnit);
        }
        for (MetricFlowUnit flowUnit : this.cacheMaxSize.getFlowUnits()) {
            if (flowUnit.isEmpty()) continue;
            this.collectCacheMaxSize(flowUnit);
        }
        for (MetricFlowUnit flowUnit : this.heapMaxSize.getFlowUnits()) {
            if (flowUnit.isEmpty()) continue;
            this.collectHeapStats(flowUnit);
        }
        if (this.counter == this.rcaPeriod) {
            this.counter = 0;
            NodeConfigFlowUnit flowUnits = new NodeConfigFlowUnit(System.currentTimeMillis(), new NodeKey(this.getInstanceDetails()));
            this.configResult.forEach(flowUnits::addConfig);
            this.configResult.clear();
            return flowUnits;
        }
        return new NodeConfigFlowUnit(System.currentTimeMillis());
    }
}

