/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.grpc.Resource;
import org.opensearch.performanceanalyzer.rca.configs.HotNodeClusterRcaConfig;
import org.opensearch.performanceanalyzer.rca.framework.api.Rca;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;

public class HotNodeClusterRca
extends Rca<ResourceFlowUnit<HotClusterSummary>> {
    public static final String RCA_TABLE_NAME = HotNodeClusterRca.class.getSimpleName();
    private static final Logger LOG = LogManager.getLogger(HotNodeClusterRca.class);
    private static final double NODE_COUNT_THRESHOLD = 0.8;
    private static final long TIMESTAMP_EXPIRATION_IN_MINS = 5L;
    private final Rca<ResourceFlowUnit<HotNodeSummary>> hotNodeRca;
    private final Table<String, Resource, NodeResourceUsage> nodeTable;
    private final int rcaPeriod;
    private int counter;
    private List<InstanceDetails> dataNodesDetails;
    private double unbalancedResourceThreshold;
    private double resourceUsageLowerBoundThreshold;
    protected Clock clock;

    public <R extends Rca<ResourceFlowUnit<HotNodeSummary>>> HotNodeClusterRca(int rcaPeriod, R hotNodeRca) {
        super(5L);
        this.rcaPeriod = rcaPeriod;
        this.counter = 0;
        this.clock = Clock.systemUTC();
        this.hotNodeRca = hotNodeRca;
        this.nodeTable = HashBasedTable.create();
        this.unbalancedResourceThreshold = 0.3;
        this.resourceUsageLowerBoundThreshold = 0.1;
    }

    private void addSummaryToNodeMap(List<ResourceFlowUnit<HotNodeSummary>> hotNodeRcaFlowUnits) {
        for (ResourceFlowUnit<HotNodeSummary> hotNodeRcaFlowUnit : hotNodeRcaFlowUnits) {
            HotNodeSummary nodeSummary;
            if (hotNodeRcaFlowUnit.isEmpty() || (nodeSummary = hotNodeRcaFlowUnit.getSummary()).getNestedSummaryList() == null || nodeSummary.getNestedSummaryList().isEmpty()) continue;
            long timestamp = this.clock.millis();
            for (HotResourceSummary resourceSummary : nodeSummary.getHotResourceSummaryList()) {
                NodeResourceUsage oldUsage = (NodeResourceUsage)this.nodeTable.get((Object)nodeSummary.getNodeID().toString(), (Object)resourceSummary.getResource());
                if (oldUsage != null && oldUsage.timestamp >= timestamp) continue;
                this.nodeTable.put((Object)nodeSummary.getNodeID().toString(), (Object)resourceSummary.getResource(), (Object)new NodeResourceUsage(timestamp, resourceSummary));
            }
        }
    }

    private ResourceFlowUnit<HotClusterSummary> checkUnbalancedNode() {
        HashMap<String, HotNodeSummary> nodeSummaryMap = new HashMap<String, HotNodeSummary>();
        long currTimestamp = this.clock.millis();
        ImmutableList resourceTypeColumnKeys = ImmutableList.copyOf((Collection)this.nodeTable.columnKeySet());
        for (Resource resourceType : resourceTypeColumnKeys) {
            ArrayList<NodeResourceUsage> resourceUsages = new ArrayList<NodeResourceUsage>();
            for (InstanceDetails nodeDetail : this.dataNodesDetails) {
                NodeResourceUsage currentUsage = (NodeResourceUsage)this.nodeTable.get((Object)nodeDetail.getInstanceId().toString(), (Object)resourceType);
                if (currentUsage == null) continue;
                if (currTimestamp - currentUsage.timestamp > TimeUnit.MINUTES.toMillis(5L)) {
                    this.nodeTable.row((Object)nodeDetail.getInstanceId().toString()).remove(resourceType);
                    continue;
                }
                resourceUsages.add(currentUsage);
            }
            int nodeCntThreshold = (int)((double)this.dataNodesDetails.size() * 0.8);
            if (nodeCntThreshold < 2) {
                nodeCntThreshold = 2;
            }
            if (resourceUsages.size() < nodeCntThreshold) continue;
            resourceUsages.sort(Comparator.comparingDouble(r -> r.resourceSummary.getValue()));
            int mediumIdx = resourceUsages.size() / 2;
            if (resourceUsages.size() % 2 == 0) {
                --mediumIdx;
            }
            double medium = ((NodeResourceUsage)resourceUsages.get((int)mediumIdx)).resourceSummary.getValue();
            for (InstanceDetails nodeDetail : this.dataNodesDetails) {
                NodeResourceUsage currentUsage = (NodeResourceUsage)this.nodeTable.get((Object)nodeDetail.getInstanceId().toString(), (Object)resourceType);
                if (currentUsage == null || !(currentUsage.resourceSummary.getValue() >= medium * (1.0 + this.unbalancedResourceThreshold)) || !(currentUsage.resourceSummary.getValue() >= currentUsage.resourceSummary.getThreshold() * this.resourceUsageLowerBoundThreshold)) continue;
                if (!nodeSummaryMap.containsKey(nodeDetail.getInstanceId().toString())) {
                    nodeSummaryMap.put(nodeDetail.getInstanceId().toString(), new HotNodeSummary(nodeDetail.getInstanceId(), nodeDetail.getInstanceIp()));
                }
                ((HotNodeSummary)nodeSummaryMap.get(nodeDetail.getInstanceId().toString())).appendNestedSummary(currentUsage.resourceSummary);
            }
        }
        HotClusterSummary summary = null;
        ResourceContext context = null;
        if (nodeSummaryMap.isEmpty()) {
            context = new ResourceContext(Resources.State.HEALTHY);
        } else {
            context = new ResourceContext(Resources.State.UNHEALTHY);
            summary = new HotClusterSummary(this.dataNodesDetails.size(), nodeSummaryMap.size());
            for (Map.Entry entry : nodeSummaryMap.entrySet()) {
                summary.appendNestedSummary((HotNodeSummary)entry.getValue());
            }
        }
        return new ResourceFlowUnit<Object>(System.currentTimeMillis(), context, summary, true);
    }

    private void removeInactiveNodeFromTable() {
        HashSet<String> nodeIdSet = new HashSet<String>();
        for (InstanceDetails nodeDetail : this.dataNodesDetails) {
            nodeIdSet.add(nodeDetail.getInstanceId().toString());
        }
        for (String nodeId : this.nodeTable.rowKeySet()) {
            if (nodeIdSet.contains(nodeId)) continue;
            this.nodeTable.row((Object)nodeId).clear();
        }
    }

    @Override
    public ResourceFlowUnit<HotClusterSummary> operate() {
        this.dataNodesDetails = this.getDataNodeInstances();
        if (this.dataNodesDetails.size() <= 1) {
            return new ResourceFlowUnit<HotClusterSummary>(System.currentTimeMillis());
        }
        ++this.counter;
        this.addSummaryToNodeMap(this.hotNodeRca.getFlowUnits());
        if (this.counter >= this.rcaPeriod) {
            this.counter = 0;
            this.removeInactiveNodeFromTable();
            return this.checkUnbalancedNode();
        }
        return new ResourceFlowUnit<HotClusterSummary>(System.currentTimeMillis());
    }

    @Override
    public void readRcaConf(RcaConf conf) {
        HotNodeClusterRcaConfig configObj = conf.getHotNodeClusterRcaConfig();
        this.unbalancedResourceThreshold = configObj.getUnbalancedResourceThreshold();
        this.resourceUsageLowerBoundThreshold = configObj.getResourceUsageLowerBoundThreshold();
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        throw new IllegalArgumentException(this.name() + "'s generateFlowUnitListFromWire() should not be required.");
    }

    private static class NodeResourceUsage {
        private final long timestamp;
        private final HotResourceSummary resourceSummary;

        NodeResourceUsage(long timestamp, HotResourceSummary resourceSummary) {
            this.timestamp = timestamp;
            this.resourceSummary = resourceSummary;
        }
    }
}

