# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
import gphoto2.abilities_list
import gphoto2.camera
import gphoto2.context
import gphoto2.file
import gphoto2.filesys
import gphoto2.list
import gphoto2.port_info_list
import gphoto2.result
import gphoto2.version
import gphoto2.widget

# Pull in all the attributes from the low-level C/C++ module
if __package__ or "." in __name__:
    from ._port_log import *
else:
    from _port_log import *


import logging
import sys

def _gphoto2_logger_cb(level, domain, msg, data):
    log_func, mapping = data
    if sys.version_info[0] >= 3:
# decode bytes to str
        if domain:
            domain = domain.decode(errors='replace')
        if msg:
            msg = msg.decode(errors='replace')
    if level in mapping:
        log_func(mapping[level], '(%s) %s', domain, msg)
    else:
        log_func(logging.ERROR, '%d (%s) %s', level, domain, msg)

def use_python_logging(mapping={}):
    """Install a callback to receive gphoto2 errors and forward them
    to Python's logging system.

    The return value is a tuple containing an error code and a Python object
    containing details of the callback. Deleting this object will uninstall
    the callback.

    Parameters
    ----------
    * `mapping` :
        a dictionary mapping any of the four gphoto2 logging severity
        levels to a Python logging level. Note that anything below Python
        DEBUG level will not be forwarded.

    Returns
    -------
    a tuple containing an id or error code and a callback reference object.

    """
    full_mapping = {
        GP_LOG_ERROR   : logging.WARNING,
        GP_LOG_VERBOSE : logging.INFO,
        GP_LOG_DEBUG   : logging.DEBUG,
        GP_LOG_DATA    : logging.DEBUG - 5,
        }
    full_mapping.update(mapping)
    log_func = logging.getLogger('gphoto2').log
    for level in (GP_LOG_DATA, GP_LOG_DEBUG, GP_LOG_VERBOSE, GP_LOG_ERROR):
        if full_mapping[level] >= logging.DEBUG:
            break
    return gp_log_add_func(level, _gphoto2_logger_cb, (log_func, full_mapping))


