/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.error.DiagramError;
import net.sf.sdedit.error.FatalError;
import net.sf.sdedit.error.SemanticError;
import net.sf.sdedit.text.TextHandler;
import net.sf.sdedit.ui.impl.DiagramErrorHandler;
import net.sf.sdedit.ui.impl.DiagramTextTab;

public class SequenceDiagramErrorHandler
extends DiagramErrorHandler {
    private DiagramTextTab tab;

    public SequenceDiagramErrorHandler(DiagramTextTab tab) {
        this.tab = tab;
    }

    private SequenceDiagram diagram() {
        return (SequenceDiagram)this.tab.getDiagram();
    }

    protected void handleBug(Diagram diagram, Throwable ex) {
        String name = "sdedit-errorlog-" + System.currentTimeMillis();
        File errorLogFile = new File(name);
        try {
            errorLogFile.createNewFile();
        }
        catch (IOException e0) {
            try {
                errorLogFile = new File(System.getProperty("user.home"), name);
                errorLogFile.createNewFile();
            }
            catch (IOException e1) {
                errorLogFile = new File(System.getProperty("java.io.tmpdir", name));
            }
        }
        try {
            this.saveLog(errorLogFile, ex, (TextHandler)diagram.getDataProvider());
        }
        catch (IOException e) {
            this.tab.get_UI().errorMessage(e, null, "An error log file could not be saved.");
        }
    }

    @Override
    public void handleDiagramError(DiagramError error) {
        if (error == null) {
            int noteNumber;
            this.tab.setError(false, "", -1, -1);
            if (this.diagram().getFragmentManager().openFragmentsExist()) {
                this.tab.setError(true, "Warning: There are open comments. Use [c:<type> <text>]...[/c]", -1, -1);
            }
            if ((noteNumber = this.diagram().getNextFreeNoteNumber()) == 0) {
                this.tab.setStatus("");
            } else {
                this.tab.setStatus("Next note number: " + this.diagram().getNextFreeNoteNumber());
            }
        } else {
            this.tab.setStatus("");
            if (error instanceof FatalError) {
                FatalError fatal = (FatalError)error;
                System.err.println("********************************************************");
                System.err.println("*                                                      *");
                System.err.println("*            A FATAL ERROR HAS OCCURED.                *");
                System.err.println("*                                                      *");
                System.err.println("********************************************************");
                error.getCause().printStackTrace();
                try {
                    this.handleBug(this.diagram(), fatal.getCause());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                TextHandler handler = (TextHandler)error.getProvider();
                String prefix = "";
                if (error instanceof SemanticError) {
                    prefix = this.diagram().isThreaded() && this.diagram().getCallerThread() != -1 ? "Thread " + this.diagram().getCallerThread() + ": " : "";
                }
                this.tab.setError(false, prefix + error.getMessage(), handler.getLineBegin() - 1, handler.getLineEnd());
            }
        }
    }

    private static final String getFatalErrorDescription(Throwable ex) {
        return "A FATAL ERROR has occurred: " + ex.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLog(File logFile, Throwable exception, TextHandler textHandler) throws IOException {
        FileOutputStream stream = new FileOutputStream(logFile);
        try {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)stream, ConfigurationManager.getGlobalConfiguration().getFileEncoding()));
            BufferedReader bufferedReader = new BufferedReader(new StringReader(textHandler.getText()));
            int error = textHandler.getLineNumber();
            printWriter.println(exception.getClass().getSimpleName() + " has occurred in line " + error + "\n");
            int i = 0;
            while (true) {
                String line;
                if ((line = bufferedReader.readLine()) == null) break;
                line = line.trim();
                if (i == error - 1) {
                    line = ">>>>>>>>>>>>>> " + line;
                }
                printWriter.println(line);
                ++i;
            }
            bufferedReader.close();
            printWriter.println("\n\n:::::::::::::::::::::::::::::\n\n");
            exception.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            this.tab.get_UI().errorMessage(null, "FATAL ERROR", SequenceDiagramErrorHandler.getFatalErrorDescription(exception) + "\n\nAn error log file has been saved under \n" + logFile.getAbsolutePath() + "\n\nPlease send an e-mail with this file as an attachment to:\nsdedit@users.sourceforge.net");
        }
        finally {
            stream.close();
        }
    }
}

