import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  DetectStackResourceDriftInput,
  DetectStackResourceDriftOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface DetectStackResourceDriftCommandInput
  extends DetectStackResourceDriftInput {}
export interface DetectStackResourceDriftCommandOutput
  extends DetectStackResourceDriftOutput,
    __MetadataBearer {}
export declare class DetectStackResourceDriftCommand extends $Command<
  DetectStackResourceDriftCommandInput,
  DetectStackResourceDriftCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: DetectStackResourceDriftCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DetectStackResourceDriftCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DetectStackResourceDriftCommandInput,
    DetectStackResourceDriftCommandOutput
  >;
  private serialize;
  private deserialize;
}
