// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

/**
 * Omit any properties starting with `_`, which are fake-private
 *
 * @type {import('stylelint').Formatter}
 */
function jsonFormatter(results) {
	const cleanedResults = results.map((result) =>
		Object.entries(result)
			.filter(([key]) => !key.startsWith('_'))
			.reduce((/** @type {{ [key: string]: any }} */ obj, [key, value]) => {
				obj[key] = value;

				return obj;
			}, {}),
	);

	return JSON.stringify(cleanedResults);
}

module.exports = jsonFormatter;
