/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.authenticator.SingleSignOnListener;
import org.apache.catalina.authenticator.SingleSignOnSessionKey;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.res.StringManager;

public class SingleSignOn
extends ValveBase {
    private static final StringManager sm = StringManager.getManager(SingleSignOn.class);
    private Engine engine;
    protected Map<String, SingleSignOnEntry> cache = new ConcurrentHashMap<String, SingleSignOnEntry>();
    private boolean requireReauthentication = false;
    private String cookieDomain;
    private String cookieName = "JSESSIONIDSSO";

    public SingleSignOn() {
        super(true);
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String string) {
        this.cookieDomain = string != null && string.trim().length() == 0 ? null : string;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String string) {
        this.cookieName = string;
    }

    public boolean getRequireReauthentication() {
        return this.requireReauthentication;
    }

    public void setRequireReauthentication(boolean bl) {
        this.requireReauthentication = bl;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Object object;
        request.removeNote("org.apache.catalina.request.SSOID");
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.invoke", new Object[]{request.getRequestURI()}));
        }
        if (request.getUserPrincipal() != null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.hasPrincipal", new Object[]{request.getUserPrincipal().getName()}));
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.cookieCheck"));
        }
        Cookie cookie = null;
        Cookie[] cookieArray = request.getCookies();
        if (cookieArray != null) {
            object = cookieArray;
            int n = ((Cookie[])object).length;
            for (int i = 0; i < n; ++i) {
                Cookie cookie2 = object[i];
                if (!this.cookieName.equals(cookie2.getName())) continue;
                cookie = cookie2;
                break;
            }
        }
        if (cookie == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.cookieNotFound"));
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.principalCheck", new Object[]{cookie.getValue()}));
        }
        if ((object = this.cache.get(cookie.getValue())) != null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.principalFound", new Object[]{((SingleSignOnEntry)object).getPrincipal() != null ? ((SingleSignOnEntry)object).getPrincipal().getName() : "", ((SingleSignOnEntry)object).getAuthType()}));
            }
            request.setNote("org.apache.catalina.request.SSOID", cookie.getValue());
            if (!this.getRequireReauthentication()) {
                request.setAuthType(((SingleSignOnEntry)object).getAuthType());
                request.setUserPrincipal(((SingleSignOnEntry)object).getPrincipal());
            }
        } else {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.principalNotFound", new Object[]{cookie.getValue()}));
            }
            cookie.setValue("REMOVE");
            cookie.setMaxAge(0);
            cookie.setPath("/");
            String string = this.getCookieDomain();
            if (string != null) {
                cookie.setDomain(string);
            }
            cookie.setSecure(request.isSecure());
            if (request.getServletContext().getSessionCookieConfig().isHttpOnly() || request.getContext().getUseHttpOnly()) {
                cookie.setHttpOnly(true);
            }
            cookie.setAttribute("Partitioned", Boolean.toString(request.getContext().getUsePartitioned()));
            response.addCookie(cookie);
        }
        this.getNext().invoke(request, response);
    }

    public void sessionDestroyed(String string, Session session) {
        if (!this.getState().isAvailable()) {
            return;
        }
        if (session.getMaxInactiveInterval() > 0 && session.getIdleTimeInternal() >= (long)(session.getMaxInactiveInterval() * 1000) || !session.getManager().getContext().getState().isAvailable()) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.sessionTimeout", new Object[]{string, session}));
            }
            this.removeSession(string, session);
        } else {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.sessionLogout", new Object[]{string, session}));
            }
            this.removeSession(string, session);
            if (this.cache.containsKey(string)) {
                this.deregister(string);
            }
        }
    }

    protected boolean associate(String string, Session session) {
        SingleSignOnEntry singleSignOnEntry = this.cache.get(string);
        if (singleSignOnEntry == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.associateFail", new Object[]{string, session}));
            }
            return false;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.associate", new Object[]{string, session}));
        }
        singleSignOnEntry.addSession(this, string, session);
        return true;
    }

    protected void deregister(String string) {
        SingleSignOnEntry singleSignOnEntry = this.cache.remove(string);
        if (singleSignOnEntry == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.deregisterFail", new Object[]{string}));
            }
            return;
        }
        Set<SingleSignOnSessionKey> set = singleSignOnEntry.findSessions();
        if (set.size() == 0 && this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.deregisterNone", new Object[]{string}));
        }
        for (SingleSignOnSessionKey singleSignOnSessionKey : set) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.deregister", new Object[]{singleSignOnSessionKey, string}));
            }
            this.expire(singleSignOnSessionKey);
        }
    }

    private void expire(SingleSignOnSessionKey singleSignOnSessionKey) {
        if (this.engine == null) {
            this.containerLog.warn((Object)sm.getString("singleSignOn.sessionExpire.engineNull", new Object[]{singleSignOnSessionKey}));
            return;
        }
        Container container = this.engine.findChild(singleSignOnSessionKey.getHostName());
        if (container == null) {
            this.containerLog.warn((Object)sm.getString("singleSignOn.sessionExpire.hostNotFound", new Object[]{singleSignOnSessionKey}));
            return;
        }
        Context context = (Context)container.findChild(singleSignOnSessionKey.getContextName());
        if (context == null) {
            this.containerLog.warn((Object)sm.getString("singleSignOn.sessionExpire.contextNotFound", new Object[]{singleSignOnSessionKey}));
            return;
        }
        Manager manager = context.getManager();
        if (manager == null) {
            this.containerLog.warn((Object)sm.getString("singleSignOn.sessionExpire.managerNotFound", new Object[]{singleSignOnSessionKey}));
            return;
        }
        Session session = null;
        try {
            session = manager.findSession(singleSignOnSessionKey.getSessionId());
        }
        catch (IOException iOException) {
            this.containerLog.warn((Object)sm.getString("singleSignOn.sessionExpire.managerError", new Object[]{singleSignOnSessionKey}), (Throwable)iOException);
            return;
        }
        if (session == null) {
            this.containerLog.warn((Object)sm.getString("singleSignOn.sessionExpire.sessionNotFound", new Object[]{singleSignOnSessionKey}));
            return;
        }
        session.expire();
    }

    protected boolean reauthenticate(String string, Realm realm, Request request) {
        Principal principal;
        String string2;
        if (string == null || realm == null) {
            return false;
        }
        boolean bl = false;
        SingleSignOnEntry singleSignOnEntry = this.cache.get(string);
        if (singleSignOnEntry != null && singleSignOnEntry.getCanReauthenticate() && (string2 = singleSignOnEntry.getUsername()) != null && (principal = realm.authenticate(string2, singleSignOnEntry.getPassword())) != null) {
            bl = true;
            request.setAuthType(singleSignOnEntry.getAuthType());
            request.setUserPrincipal(principal);
        }
        return bl;
    }

    protected void register(String string, Principal principal, String string2, String string3, String string4) {
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.register", new Object[]{string, principal != null ? principal.getName() : "", string2}));
        }
        this.cache.put(string, new SingleSignOnEntry(principal, string2, string3, string4));
    }

    protected boolean update(String string, Principal principal, String string2, String string3, String string4) {
        SingleSignOnEntry singleSignOnEntry = this.cache.get(string);
        if (singleSignOnEntry != null && !singleSignOnEntry.getCanReauthenticate()) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.update", new Object[]{string, string2}));
            }
            singleSignOnEntry.updateCredentials(principal, string2, string3, string4);
            return true;
        }
        return false;
    }

    protected void removeSession(String string, Session session) {
        SingleSignOnEntry singleSignOnEntry;
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.removeSession", new Object[]{session, string}));
        }
        if ((singleSignOnEntry = this.cache.get(string)) == null) {
            return;
        }
        singleSignOnEntry.removeSession(session);
        if (singleSignOnEntry.findSessions().size() == 0) {
            this.deregister(string);
        }
    }

    protected SessionListener getSessionListener(String string) {
        return new SingleSignOnListener(string);
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        Container container;
        for (container = this.getContainer(); container != null && !(container instanceof Engine); container = container.getParent()) {
        }
        if (container != null) {
            this.engine = (Engine)container;
        }
        super.startInternal();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.engine = null;
    }
}

