/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.el;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELManager;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.StaticFieldELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.jasper.Constants;

public class ELContextImpl
extends ELContext {
    private static final FunctionMapper NullFunctionMapper = new FunctionMapper(){

        public Method resolveFunction(String string, String string2) {
            return null;
        }
    };
    private static final ELResolver DefaultResolver;
    private final ELResolver resolver;
    private FunctionMapper functionMapper = NullFunctionMapper;
    private VariableMapper variableMapper;

    public ELContextImpl(ExpressionFactory expressionFactory) {
        this(ELContextImpl.getDefaultResolver(expressionFactory));
    }

    public ELContextImpl(ELResolver eLResolver) {
        this.resolver = eLResolver;
    }

    public ELResolver getELResolver() {
        return this.resolver;
    }

    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    public VariableMapper getVariableMapper() {
        if (this.variableMapper == null) {
            this.variableMapper = new VariableMapperImpl();
        }
        return this.variableMapper;
    }

    public void setFunctionMapper(FunctionMapper functionMapper) {
        this.functionMapper = functionMapper;
    }

    public void setVariableMapper(VariableMapper variableMapper) {
        this.variableMapper = variableMapper;
    }

    public static ELResolver getDefaultResolver(ExpressionFactory expressionFactory) {
        if (Constants.IS_SECURITY_ENABLED) {
            CompositeELResolver compositeELResolver = new CompositeELResolver();
            compositeELResolver.add(expressionFactory.getStreamELResolver());
            compositeELResolver.add((ELResolver)new StaticFieldELResolver());
            compositeELResolver.add((ELResolver)new MapELResolver());
            compositeELResolver.add((ELResolver)new ResourceBundleELResolver());
            compositeELResolver.add((ELResolver)new ListELResolver());
            compositeELResolver.add((ELResolver)new ArrayELResolver());
            compositeELResolver.add((ELResolver)new BeanELResolver());
            return compositeELResolver;
        }
        return DefaultResolver;
    }

    static {
        if (Constants.IS_SECURITY_ENABLED) {
            DefaultResolver = null;
        } else {
            DefaultResolver = new CompositeELResolver();
            ((CompositeELResolver)DefaultResolver).add(ELManager.getExpressionFactory().getStreamELResolver());
            ((CompositeELResolver)DefaultResolver).add((ELResolver)new StaticFieldELResolver());
            ((CompositeELResolver)DefaultResolver).add((ELResolver)new MapELResolver());
            ((CompositeELResolver)DefaultResolver).add((ELResolver)new ResourceBundleELResolver());
            ((CompositeELResolver)DefaultResolver).add((ELResolver)new ListELResolver());
            ((CompositeELResolver)DefaultResolver).add((ELResolver)new ArrayELResolver());
            ((CompositeELResolver)DefaultResolver).add((ELResolver)new BeanELResolver());
        }
    }

    private static final class VariableMapperImpl
    extends VariableMapper {
        private Map<String, ValueExpression> vars;

        private VariableMapperImpl() {
        }

        public ValueExpression resolveVariable(String string) {
            if (this.vars == null) {
                return null;
            }
            return this.vars.get(string);
        }

        public ValueExpression setVariable(String string, ValueExpression valueExpression) {
            if (this.vars == null) {
                this.vars = new HashMap<String, ValueExpression>();
            }
            if (valueExpression == null) {
                return this.vars.remove(string);
            }
            return this.vars.put(string, valueExpression);
        }
    }
}

