/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.math.BigDecimal;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Rate;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;

public final class RateHelper {
    public static double convertToHours(ProjectFile file, Rate rate) {
        double amount = rate.getAmount();
        switch (rate.getUnits()) {
            case MINUTES: {
                amount /= 60.0;
                break;
            }
            case DAYS: {
                amount = amount * 60.0 / file.getProjectProperties().getMinutesPerDay().doubleValue();
                break;
            }
            case WEEKS: {
                amount = amount * 60.0 / file.getProjectProperties().getMinutesPerWeek().doubleValue();
                break;
            }
            case MONTHS: {
                amount = amount * 60.0 / file.getProjectProperties().getMinutesPerMonth().doubleValue();
                break;
            }
            case YEARS: {
                amount = amount * 60.0 / (double)(file.getProjectProperties().getMinutesPerWeek() * 52);
                break;
            }
        }
        return amount;
    }

    public static Rate convertFromHours(ProjectFile file, Rate rate, TimeUnit targetUnits) {
        return RateHelper.convertFromHours(file, rate.getAmount(), targetUnits);
    }

    public static Rate convertFromHours(ProjectFile file, BigDecimal value, TimeUnit targetUnits) {
        if (targetUnits == TimeUnit.YEARS) {
            double v = (double)((long)(value.doubleValue() * file.getProjectProperties().getMinutesPerWeek().doubleValue() * 52.0)) / 60.0;
            return new Rate(NumberHelper.round(v, 2.0), targetUnits);
        }
        return RateHelper.convertFromHours(file, value.doubleValue(), targetUnits);
    }

    public static Rate convertFromHours(ProjectFile file, double value, TimeUnit targetUnits) {
        switch (targetUnits) {
            case MINUTES: {
                value /= 60.0;
                break;
            }
            case DAYS: {
                value = value * file.getProjectProperties().getMinutesPerDay().doubleValue() / 60.0;
                break;
            }
            case WEEKS: {
                value = value * file.getProjectProperties().getMinutesPerWeek().doubleValue() / 60.0;
                break;
            }
            case MONTHS: {
                value = value * file.getProjectProperties().getMinutesPerMonth().doubleValue() / 60.0;
                break;
            }
            case YEARS: {
                value = value * file.getProjectProperties().getMinutesPerWeek().doubleValue() * 52.0 / 60.0;
                break;
            }
        }
        return new Rate(NumberHelper.round(value, 2.0), targetUnits);
    }
}

