/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.rest;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rest.RequestMapping;
import org.jkiss.utils.rest.RequestParameter;
import org.jkiss.utils.rest.RestProxy;
import org.jkiss.utils.rest.RpcException;

public abstract class RpcInvocationHandler
implements InvocationHandler,
RestProxy {
    @NotNull
    private final Class<?> clientClass;
    protected final URI uri;
    protected final Gson gson;
    protected final String userAgent;
    protected final ThreadLocal<Type> resultType = new ThreadLocal();

    protected RpcInvocationHandler(@NotNull Class<?> clientClass, @NotNull URI uri, @NotNull Gson gson, @NotNull String userAgent) {
        this.clientClass = clientClass;
        this.uri = uri;
        this.gson = gson;
        this.userAgent = userAgent;
    }

    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnType;
        String contents;
        block26: {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == Object.class) {
                return BeanUtils.handleObjectMethod(proxy, method, args);
            }
            if (declaringClass == RestProxy.class) {
                this.setNextCallResultType((Type)args[0]);
                return null;
            }
            if (method.getName().equals("close") && (declaringClass == AutoCloseable.class || declaringClass == this.clientClass)) {
                this.closeClient();
                return null;
            }
            if (this.isClientClosed()) {
                throw new RpcException("Rest client has been terminated");
            }
            RequestMapping mapping = method.getDeclaredAnnotation(RequestMapping.class);
            Parameter[] parameters = method.getParameters();
            LinkedHashMap<String, JsonElement> values = new LinkedHashMap<String, JsonElement>(parameters.length);
            int i = 0;
            while (i < parameters.length) {
                JsonElement argument;
                String paramName;
                Parameter p = parameters[i];
                RequestParameter param = p.getDeclaredAnnotation(RequestParameter.class);
                String string = paramName = param == null ? p.getName() : param.value();
                if (CommonUtils.isEmptyTrimmed(paramName)) {
                    throw RpcInvocationHandler.createException(method, "one or more of parameters has empty name (it can be specified in @RequestParameter)");
                }
                try {
                    argument = this.gson.toJsonTree(args[i]);
                }
                catch (Throwable e) {
                    throw new RpcException("Failed to serialize argument " + i + ": " + e.getMessage(), e);
                }
                if (values.put(paramName, argument) != null) {
                    throw RpcInvocationHandler.createException(method, "one or more of its parameters share the same name specified in @RequestParameter");
                }
                ++i;
            }
            contents = this.invokeRemoteMethod(method, mapping, values);
            returnType = this.resultType.get();
            if (returnType == null) {
                returnType = method.getGenericReturnType();
            } else {
                this.resultType.remove();
            }
            if (returnType != Void.TYPE) break block26;
            return null;
        }
        try {
            Type[] bounds;
            if (returnType instanceof TypeVariable && (bounds = ((TypeVariable)returnType).getBounds()).length > 0) {
                returnType = bounds[0];
            }
            if (returnType instanceof ParameterizedType && ((ParameterizedType)returnType).getRawType() == Class.class) {
                returnType = Class.class;
            }
            return this.gson.fromJson(contents, (Type)returnType);
        }
        catch (RpcException e) {
            if (e.getErrorClass() != null) {
                Throwable error = null;
                try {
                    Class<?> errorClass = Class.forName(e.getErrorClass(), true, proxy.getClass().getClassLoader());
                    try {
                        error = (Throwable)errorClass.getConstructor(String.class, Throwable.class).newInstance(e.getMessage(), e);
                    }
                    catch (Exception exception) {
                        error = (Throwable)errorClass.getConstructor(String.class).newInstance(e.getMessage());
                    }
                }
                catch (Throwable throwable) {}
                if (error != null) {
                    throw error;
                }
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RpcException(e);
        }
    }

    protected abstract boolean isClientClosed();

    protected abstract String invokeRemoteMethod(@NotNull Method var1, @Nullable RequestMapping var2, @NotNull Map<String, JsonElement> var3);

    protected abstract void closeClient();

    @NotNull
    private static RpcException createException(@NotNull Method method, @NotNull String reason) {
        return new RpcException("Unable to invoke the method " + String.valueOf(method) + " because " + reason);
    }

    @Override
    public void setNextCallResultType(Type type) {
        this.resultType.set(type);
    }
}

