---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Runners, jobs, pipelines, variables.
title: CI/CDを使用してアプリケーションを構築する
---

CI/CD（継続的インテグレーション/継続的デリバリー）を使用してアプリケーションを生成します。

|                                                                                                                      |                                                                                                                                                    |                                                                                                                           |
|----------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------|
| [**はじめに**](../ci/_index.md)<br>CI/CD機能の仕組みの概要                               | [**CI/CD YAML構文リファレンス**](../ci/yaml/_index.md)<br>パイプライン設定キーワード、構文、例、インプット                               | [**Runner**](../ci/runners/_index.md)<br>設定、ジョブの実行                                                   |
| [**パイプライン**](../ci/pipelines/_index.md)<br>設定、自動化、ステージ、スケジュール、効率性              | [**ジョブ**](../ci/jobs/_index.md)<br>設定、ルール、キャッシュ、アーティファクト、ログ                                                                | [**CI/CDコンポーネント**](../ci/components/_index.md)<br>パイプライン用の再利用可能でバージョン管理されたCI/CDコンポーネント                  |
| [**CI/CD変数**](../ci/variables/_index.md)<br>設定、使用方法、セキュリティ                                   | [**パイプラインセキュリティ**](../ci/pipelines/pipeline_security.md)<br>シークレット管理、ジョブトークン、セキュアファイル、クラウドセキュリティ                     | [**デバッグ**](../ci/debugging.md)<br>設定の検証、警告、エラー、トラブルシューティング                       |
| [**Auto DevOps**](autodevops/_index.md)<br>自動化されたDevOps、言語検出、デプロイ、カスタマイズ           | [**テスト**](../ci/testing/_index.md)<br>ユニットテスト、インテグレーションテスト、テストレポート、カバレッジ、品質管理                                | [**Google Cloudインテグレーション**](../ci/gitlab_google_cloud_integration/_index.md)<br>クラウドサービス、Kubernetesデプロイ |
| [**GitLab CI/CDに移行する**](../ci/migration/plan_a_migration.md)<br> Jenkins、GitHub Actionsなどから移行する | [**外部リポジトリのインテグレーション**](../ci/ci_cd_for_external_repos/_index.md)<br>GitHub、Bitbucket、外部ソース、ミラーリング、クロスプラットフォーム |                                                                                                                           |
