---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Adobe client secret'
---

## Description

The response body contains content that matches the pattern of an Adobe client secret was detected. Adobe client secrets are used to connect to various API or webhook event based services. Depending on which type of service was defined for a project, a malicious actor with access to the secret can use it to gain access to various APIs or events that may contain sensitive information.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).
Remediation steps depend on which type of client secret was leaked, please see the following types of remediation steps below and use the one that applies to the secret that was detected.

OAuth (Server-to-Server):

- Sign in to your account at <https://developer.adobe.com/console>
- Select the project or "All projects" to find the project that is impacted - On the left-hand side, under "Credentials", select "OAuth Server-to-Server"
- Under "Client Secret" select "Retrieve client secret"
- After the table of secrets is visible, below the table, select "Add new client secret"
- After the new secret has been created, find the leaked token value and select the trash icon to remove it
- Copy the secret value and update all services with the new client secret

OAuth Web App (Event based project):

- Select the project or select "All projects" to find the project that is impacted
- On the left-hand side, under "Credentials", select "OAuth Web App".
- Select "Retrieve client secret"
- Verify this is the leaked secret
- If this project is configured for events, copy all event details before removing it. You can do this by finding the event listed on the right hand side and selecting on it. You should be brought to a dashboard that shows its details such as event delivery methods, providers, subscribed events, and connected Credentials.
- To remove the event, select "..." in the event, which is on the right hand side of the project page, above "Connect another service".
- Select "remove"
- When prompted, type in the project name and select "Delete Events Registration"
- In the top right-hand corner, select "Delete credential"
- When prompted, type in the project name and select "Delete Credential"
- Re-add the event with the same details as before
- When prompted to add back the Credentials, be sure to use "User Authentication" OAuth
- Select "Web App" for OAuth 2.0 authentication and authorization
- After the event has been re-added, under "Credentials" on left hand side, select "OAuth Web App"
- Select "Retrieve client secret"
- Copy the secret value and update all services with the new client secret

OAuth Web App (API Service based project):

- Sign in to your account at <https://developer.adobe.com/console>
- Select the project or select "All projects" to find the project that is impacted
- On the left-hand side, under "Credentials", select "OAuth Web App"
- Select "Retrieve client secret"
- If this project is configured for API, select the trash icon "Remove" to remove the connected product and service.
- When prompted, enter the project name and select "Remove API"
- In the top right-hand corner, select "Delete credential"
- When prompted, type in the project name and select "Delete Credential"
- Re-add the API with the same details as before
- Select "Web App" for OAuth 2.0 authentication and authorization
- After the service has been re-added, on the left-hand side under "Credentials", select "OAuth Web App"
- Select "Retrieve client secret"
- Copy the secret value and update all services with the new client secret

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.3 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
