/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities the gir-to-d pakage


module glib.StaticPrivate;

private import glib.c.functions;
public  import glib.c.types;


/**
 * A #GStaticPrivate works almost like a #GPrivate, but it has one
 * significant advantage. It doesn't need to be created at run-time
 * like a #GPrivate, but can be defined at compile-time. This is
 * similar to the difference between #GMutex and #GStaticMutex.
 * 
 * Now look at our give_me_next_number() example with #GStaticPrivate:
 * |[
 * int
 * give_me_next_number ()
 * {
 * static GStaticPrivate current_number_key = G_STATIC_PRIVATE_INIT;
 * int *current_number = g_static_private_get (&current_number_key);
 * 
 * if (!current_number)
 * {
 * current_number = g_new (int, 1);
 * *current_number = 0;
 * g_static_private_set (&current_number_key, current_number, g_free);
 * }
 * 
 * *current_number = calc_next_number (*current_number);
 * 
 * return *current_number;
 * }
 * ]|
 */
public class StaticPrivate
{
	/** the main Gtk struct */
	protected GStaticPrivate* gStaticPrivate;
	protected bool ownedRef;

	/** Get the main Gtk struct */
	public GStaticPrivate* getStaticPrivateStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return gStaticPrivate;
	}

	/** the main Gtk struct as a void* */
	protected void* getStruct()
	{
		return cast(void*)gStaticPrivate;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (GStaticPrivate* gStaticPrivate, bool ownedRef = false)
	{
		this.gStaticPrivate = gStaticPrivate;
		this.ownedRef = ownedRef;
	}

	~this ()
	{
		if ( ownedRef )
			g_static_private_free(gStaticPrivate);
	}


	/**
	 * Releases all resources allocated to @private_key.
	 *
	 * You don't have to call this functions for a #GStaticPrivate with an
	 * unbounded lifetime, i.e. objects declared 'static', but if you have
	 * a #GStaticPrivate as a member of a structure and the structure is
	 * freed, you should also free the #GStaticPrivate.
	 */
	public void free()
	{
		g_static_private_free(gStaticPrivate);
		ownedRef = false;
	}

	/**
	 * Works like g_private_get() only for a #GStaticPrivate.
	 *
	 * This function works even if g_thread_init() has not yet been called.
	 *
	 * Returns: the corresponding pointer
	 */
	public void* get()
	{
		return g_static_private_get(gStaticPrivate);
	}

	/**
	 * Initializes @private_key. Alternatively you can initialize it with
	 * %G_STATIC_PRIVATE_INIT.
	 */
	public void init()
	{
		g_static_private_init(gStaticPrivate);
	}

	/**
	 * Sets the pointer keyed to @private_key for the current thread and
	 * the function @notify to be called with that pointer (%NULL or
	 * non-%NULL), whenever the pointer is set again or whenever the
	 * current thread ends.
	 *
	 * This function works even if g_thread_init() has not yet been called.
	 * If g_thread_init() is called later, the @data keyed to @private_key
	 * will be inherited only by the main thread, i.e. the one that called
	 * g_thread_init().
	 *
	 * @notify is used quite differently from @destructor in g_private_new().
	 *
	 * Params:
	 *     data = the new pointer
	 *     notify = a function to be called with the pointer whenever the
	 *         current thread ends or sets this pointer again
	 */
	public void set(void* data, GDestroyNotify notify)
	{
		g_static_private_set(gStaticPrivate, data, notify);
	}
}
