/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.testng.reporters.Buffer;
import org.testng.reporters.IBuffer;
import org.testng.reporters.RuntimeBehavior;

public final class XMLUtils {
    private static final String EOL = RuntimeBehavior.getDefaultLineSeparator();

    private XMLUtils() {
    }

    public static String xml(String indent, String name, @Nullable String content, @Nullable Properties attributes) {
        IBuffer result = Buffer.create();
        XMLUtils.xmlOpen(result, indent, name, attributes, true);
        if (content != null) {
            result.append(content);
        }
        XMLUtils.xmlClose(result, "", name, XMLUtils.extractComment(name, attributes));
        return result.toString();
    }

    public static String extractComment(String tag, Properties properties) {
        String[] attributes;
        if (properties == null || "span".equals(tag)) {
            return null;
        }
        for (String a : attributes = new String[]{"id", "name", "class"}) {
            String comment = properties.getProperty(a);
            if (comment == null) continue;
            return " <!-- " + comment.replaceAll("[-]{2,}", "-") + " -->";
        }
        return null;
    }

    public static void xmlOptional(IBuffer result, String sp, String elementName, Boolean value, Properties attributes) {
        if (null != value) {
            XMLUtils.xmlRequired(result, sp, elementName, value.toString(), attributes);
        }
    }

    public static void xmlOptional(IBuffer result, String sp, String elementName, @Nullable String value, Properties attributes) {
        if (null != value) {
            XMLUtils.xmlRequired(result, sp, elementName, value, attributes);
        }
    }

    public static void xmlRequired(IBuffer result, String sp, String elementName, @Nullable String value, @Nullable Properties attributes) {
        result.append(XMLUtils.xml(sp, elementName, value, attributes));
    }

    public static void xmlOpen(IBuffer result, String indent, String tag, Properties attributes) {
        XMLUtils.xmlOpen(result, indent, tag, attributes, false);
    }

    public static void appendAttributes(IBuffer result, Properties attributes) {
        if (null != attributes) {
            Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> element;
                Map.Entry<Object, Object> entry = element = iterator.next();
                String key = entry.getKey().toString();
                String value = XMLUtils.escape(entry.getValue().toString());
                result.append(" ").append(key).append("=\"").append(value).append("\"");
            }
        }
    }

    public static void xmlOpen(IBuffer result, String indent, String tag, Properties attributes, boolean noNewLine) {
        result.append(indent).append("<").append(tag);
        XMLUtils.appendAttributes(result, attributes);
        result.append(">");
        if (!noNewLine) {
            result.append(EOL);
        }
    }

    public static void xmlClose(IBuffer result, String indent, String tag, String comment) {
        result.append(indent).append("</").append(tag).append(">").append(Optional.ofNullable(comment).orElse("")).append(EOL);
    }

    public static String escape(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(input);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

