#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 chimera
version:              0.4.1.0
visibility:           public
id:                   chimera-0.4.1.0-ADYMqSdTKjQ91nWM6FUdO
key:                  chimera-0.4.1.0-ADYMqSdTKjQ91nWM6FUdO
license:              BSD-3-Clause
copyright:            2017-2019 Bodigrim
maintainer:           andrew.lelechenko@gmail.com
author:               Bodigrim
homepage:             https://github.com/Bodigrim/chimera#readme
synopsis:
    Lazy infinite streams with O(1) indexing and applications for memoization

description:
    There are plenty of memoizing libraries on Hackage, but they
    usually fall into two categories:

    * Store cache as a flat array, enabling us
    to obtain cached values in O(1) time, which is nice.
    The drawback is that one must specify the size
    of the array beforehand,
    limiting an interval of inputs,
    and actually allocate it at once.
    * Store cache as a lazy binary tree.
    Thanks to laziness, one can freely use the full range of inputs.
    The drawback is that obtaining values from a tree
    takes logarithmic time and is unfriendly to CPU cache,
    which kinda defeats the purpose.

    This package intends to tackle both issues,
    providing a data type '\''Chimera'\'' for
    lazy infinite compact streams with cache-friendly O(1) indexing.

    Additional features include:

    * memoization of recursive functions and recurrent sequences,
    * memoization of functions of several, possibly signed arguments,
    * efficient memoization of boolean predicates.

category:             Data
abi:                  64d0a3e974a694cfcd8b22c05e198151
exposed:              True
exposed-modules:
    Data.Chimera Data.Chimera.ContinuousMapping
    Data.Chimera.WheelMapping

hidden-modules:
    Data.Chimera.Compat Data.Chimera.FromIntegral Data.Chimera.Internal
    Data.Chimera.Memoize

import-dirs:          /usr/lib/ghc-9.6.6/site-local/chimera-0.4.1.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/chimera-0.4.1.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/chimera-0.4.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-chimera
hs-libraries:         HSchimera-0.4.1.0-ADYMqSdTKjQ91nWM6FUdO
depends:
    adjunctions-4.4.3-ERAaQIASkmX1lK0cNQ8bhh base-4.18.2.1
    distributive-0.6.2.1-DdTap9r39UN7HPZNMIERG3
    infinite-list-0.1.3-JCaAZ04VcJ2qYX4tm7URK mtl-2.3.1
    primitive-0.9.1.0-6uX3awsflEb6ebVZsasp0o transformers-0.6.1.0
    vector-0.13.2.0-8Ien1418VpU5tGTMA2qRu7

haddock-interfaces:   /usr/share/doc/haskell-chimera/html/chimera.haddock
haddock-html:         /usr/share/doc/haskell-chimera/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

