/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.PersistentMapImpl;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public abstract class AbstractStateStorage<Key, T>
implements StorageOwner {
    private static final boolean DO_COMPRESS = Boolean.parseBoolean(System.getProperty("jps.storage.do.compression", "true"));
    protected final Object dataLock;
    @NotNull
    private final PersistentMapBuilder<Key, T> mapBuilder;
    @NotNull
    private PersistentMapImpl<Key, T> map;
    private final boolean isCompressed;

    public AbstractStateStorage(File storePath, KeyDescriptor<Key> keyDescriptor, DataExternalizer<T> stateExternalizer) throws IOException {
        this(PersistentMapBuilder.newBuilder((Path)storePath.toPath(), keyDescriptor, stateExternalizer), DO_COMPRESS);
    }

    @ApiStatus.Internal
    protected AbstractStateStorage(@NotNull PersistentMapBuilder<Key, T> mapBuilder) throws IOException {
        if (mapBuilder == null) {
            AbstractStateStorage.$$$reportNull$$$0(0);
        }
        this(mapBuilder, DO_COMPRESS);
    }

    @ApiStatus.Internal
    protected AbstractStateStorage(@NotNull PersistentMapBuilder<Key, T> mapBuilder, boolean isCompressed) throws IOException {
        if (mapBuilder == null) {
            AbstractStateStorage.$$$reportNull$$$0(1);
        }
        this.dataLock = new Object();
        this.isCompressed = isCompressed;
        this.mapBuilder = mapBuilder;
        this.map = this.createMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void force() {
        Object object = this.dataLock;
        synchronized (object) {
            try {
                this.map.force();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        Object object = this.dataLock;
        synchronized (object) {
            this.map.close();
        }
    }

    @Override
    public final void clean() throws IOException {
        this.wipe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean wipe() {
        Object object = this.dataLock;
        synchronized (object) {
            this.map.closeAndDelete();
            try {
                this.map = this.createMap();
            }
            catch (IOException ignored) {
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Key key, @Nullable T state) throws IOException {
        if (state != null) {
            Object object = this.dataLock;
            synchronized (object) {
                this.map.put(key, state);
            }
        } else {
            this.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendData(Key key, T data) throws IOException {
        Object object = this.dataLock;
        synchronized (object) {
            this.map.appendData(key, out -> this.mapBuilder.getValueExternalizer().save(out, data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Key key) throws IOException {
        Object object = this.dataLock;
        synchronized (object) {
            this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getState(Key key) throws IOException {
        Object object = this.dataLock;
        synchronized (object) {
            return (T)this.map.get(key);
        }
    }

    @Deprecated(forRemoval=true)
    @TestOnly
    @ApiStatus.Internal
    public final Collection<Key> getKeys() throws IOException {
        return this.getAllKeys();
    }

    @NotNull
    public Iterator<Key> getKeysIterator() throws IOException {
        Iterator<Key> iterator = this.getAllKeys().iterator();
        if (iterator == null) {
            AbstractStateStorage.$$$reportNull$$$0(2);
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public final List<Key> getAllKeys() throws IOException {
        Object object = this.dataLock;
        // MONITORENTER : object
        ArrayList result = new ArrayList();
        this.map.processExistingKeys((Processor)new CommonProcessors.CollectProcessor(result));
        List list = result.isEmpty() ? List.of() : result;
        // MONITOREXIT : object
        if (list != null) return list;
        AbstractStateStorage.$$$reportNull$$$0(3);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected final Iterator<Key> getKeyIterator(@NotNull Function<Key, Key> mapper) throws IOException {
        if (mapper == null) {
            AbstractStateStorage.$$$reportNull$$$0(4);
        }
        Object object = this.dataLock;
        // MONITORENTER : object
        ArrayList result = new ArrayList();
        this.map.processExistingKeys(key -> {
            result.add(mapper.apply(key));
            return true;
        });
        Iterator<Object> iterator = result.isEmpty() ? Collections.emptyIterator() : result.iterator();
        // MONITOREXIT : object
        if (iterator != null) return iterator;
        AbstractStateStorage.$$$reportNull$$$0(5);
        return iterator;
    }

    @NotNull
    private PersistentMapImpl<Key, T> createMap() throws IOException {
        Files.createDirectories(this.mapBuilder.getFile().getParent(), new FileAttribute[0]);
        return new PersistentMapImpl(this.mapBuilder, new PersistentHashMapValueStorage.CreationTimeOptions(false, false, false, this.isCompressed));
    }

    @Override
    public final void flush(boolean memoryCachesOnly) {
        if (!memoryCachesOnly) {
            this.force();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/AbstractStateStorage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/AbstractStateStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysIterator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKeyIterator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

