/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import sun.util.locale.provider.AvailableLanguageTags;
import sun.util.locale.provider.LocaleProviderAdapter;

public class DateFormatProviderImpl
extends DateFormatProvider
implements AvailableLanguageTags {
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;

    public DateFormatProviderImpl(LocaleProviderAdapter.Type type, Set<String> set) {
        this.type = type;
        this.langtags = set;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.toLocaleArray(this.langtags);
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        return LocaleProviderAdapter.isSupportedLocale(locale, this.type, this.langtags);
    }

    @Override
    public DateFormat getTimeInstance(int n, Locale locale) {
        return this.getInstance(-1, n, locale);
    }

    @Override
    public DateFormat getDateInstance(int n, Locale locale) {
        return this.getInstance(n, -1, locale);
    }

    @Override
    public DateFormat getDateTimeInstance(int n, int n2, Locale locale) {
        return this.getInstance(n, n2, locale);
    }

    private DateFormat getInstance(int n, int n2, Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("", locale);
        Calendar calendar = simpleDateFormat.getCalendar();
        try {
            String string = LocaleProviderAdapter.forType(this.type).getLocaleResources(locale).getDateTimePattern(n2, n, calendar);
            simpleDateFormat.applyPattern(string);
        }
        catch (MissingResourceException missingResourceException) {
            simpleDateFormat.applyPattern("M/d/yy h:mm a");
        }
        return simpleDateFormat;
    }

    @Override
    public Set<String> getAvailableLanguageTags() {
        return this.langtags;
    }
}

