/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import java.util.Objects;

public final class Maybe<T> {
    private final T nullableValue;
    private final boolean defined;

    public static <T> Maybe<T> defined(T nullableValue) {
        return new Maybe<T>(nullableValue);
    }

    public static <T> Maybe<T> undefined() {
        return new Maybe<T>();
    }

    private Maybe(T nullableValue) {
        this.nullableValue = nullableValue;
        this.defined = true;
    }

    private Maybe() {
        this.nullableValue = null;
        this.defined = false;
    }

    public T getNullableValue() {
        if (this.defined) {
            return this.nullableValue;
        }
        throw new NoSuchElementException();
    }

    public boolean isDefined() {
        return this.defined;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Maybe maybe = (Maybe)o;
        return this.defined == maybe.defined && (!this.defined || Objects.equals(this.nullableValue, maybe.nullableValue));
    }

    public int hashCode() {
        return this.defined ? (this.nullableValue == null ? 0 : this.nullableValue.hashCode()) : -1;
    }

    public String toString() {
        if (this.defined) {
            return "DefinedMaybe{" + String.valueOf(this.nullableValue) + "}";
        }
        return "UndefinedMaybe{}";
    }
}

