/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public abstract class ShutdownableThread
extends Thread {
    public final String logPrefix;
    protected final Logger log;
    private final boolean isInterruptible;
    private final CountDownLatch shutdownInitiated = new CountDownLatch(1);
    private final CountDownLatch shutdownComplete = new CountDownLatch(1);
    private volatile boolean isStarted = false;

    public ShutdownableThread(String name) {
        this(name, true);
    }

    public ShutdownableThread(String name, boolean isInterruptible) {
        this(name, isInterruptible, "[" + name + "]: ");
    }

    public ShutdownableThread(String name, boolean isInterruptible, String logPrefix) {
        super(name);
        this.isInterruptible = isInterruptible;
        this.logPrefix = logPrefix;
        this.log = new LogContext(logPrefix).logger(this.getClass());
        this.setDaemon(false);
    }

    public void shutdown() throws InterruptedException {
        this.initiateShutdown();
        this.awaitShutdown();
    }

    public boolean isShutdownInitiated() {
        return this.shutdownInitiated.getCount() == 0L;
    }

    public boolean isShutdownComplete() {
        return this.shutdownComplete.getCount() == 0L;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isThreadFailed() {
        return this.isShutdownComplete() && !this.isShutdownInitiated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initiateShutdown() {
        ShutdownableThread shutdownableThread = this;
        synchronized (shutdownableThread) {
            if (this.isRunning()) {
                this.log.info("Shutting down");
                this.shutdownInitiated.countDown();
                if (this.isInterruptible) {
                    this.interrupt();
                }
                return true;
            }
            return false;
        }
    }

    public void awaitShutdown() throws InterruptedException {
        if (!this.isShutdownInitiated()) {
            throw new IllegalStateException("initiateShutdown() was not called before awaitShutdown()");
        }
        if (this.isStarted) {
            this.shutdownComplete.await();
        }
        this.log.info("Shutdown completed");
    }

    public void pause(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.shutdownInitiated.await(timeout, unit)) {
            this.log.trace("shutdownInitiated latch count reached zero. Shutdown called.");
        }
    }

    public abstract void doWork();

    @Override
    public void run() {
        this.isStarted = true;
        this.log.info("Starting");
        try {
            while (this.isRunning()) {
                this.doWork();
            }
        }
        catch (FatalExitError e) {
            this.shutdownInitiated.countDown();
            this.shutdownComplete.countDown();
            this.log.error("Stopped due to fatal error with exit code {}", (Object)e.statusCode(), (Object)e);
            Exit.exit((int)e.statusCode());
        }
        catch (Throwable e) {
            if (this.isRunning()) {
                this.log.error("Error due to", e);
            }
        }
        finally {
            this.shutdownComplete.countDown();
        }
        this.log.info("Stopped");
    }

    public boolean isRunning() {
        return !this.isShutdownInitiated();
    }
}

