/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Set;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecordSerde;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordSerde;
import org.apache.kafka.coordinator.group.generated.CoordinatorRecordJsonConverters;
import org.apache.kafka.coordinator.group.generated.CoordinatorRecordType;
import org.apache.kafka.tools.consumer.CoordinatorRecordMessageFormatter;

public class OffsetsMessageFormatter
extends CoordinatorRecordMessageFormatter {
    private static final Set<Short> ALLOWED_RECORDS = Set.of(Short.valueOf(CoordinatorRecordType.LEGACY_OFFSET_COMMIT.id()), Short.valueOf(CoordinatorRecordType.OFFSET_COMMIT.id()));

    public OffsetsMessageFormatter() {
        super((CoordinatorRecordSerde)new GroupCoordinatorRecordSerde());
    }

    @Override
    protected boolean isRecordTypeAllowed(short recordType) {
        return ALLOWED_RECORDS.contains(recordType);
    }

    @Override
    protected JsonNode keyAsJson(ApiMessage message) {
        return CoordinatorRecordJsonConverters.writeRecordKeyAsJson((ApiMessage)message);
    }

    @Override
    protected JsonNode valueAsJson(ApiMessage message, short version) {
        return CoordinatorRecordJsonConverters.writeRecordValueAsJson((ApiMessage)message, (short)version);
    }
}

