/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd;

import java.util.List;
import org.keycloak.federation.sssd.SSSDFederationProvider;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.ReadOnlyException;

public class ReadonlySSSDUserModelDelegate
extends UserModelDelegate
implements UserModel {
    private final SSSDFederationProvider provider;

    public ReadonlySSSDUserModelDelegate(UserModel delegate, SSSDFederationProvider provider) {
        super(delegate);
        this.provider = provider;
    }

    public void setUsername(String username) {
        throw new ReadOnlyException("Federated storage is not writable");
    }

    public void setLastName(String lastName) {
        throw new ReadOnlyException("Federated storage is not writable");
    }

    public void setFirstName(String first) {
        throw new ReadOnlyException("Federated storage is not writable");
    }

    public void setSingleAttribute(String name, String value) {
        this.setSpecialAttributesToReadonly(name);
        super.setSingleAttribute(name, value);
    }

    public void setAttribute(String name, List<String> value) {
        this.setSpecialAttributesToReadonly(name);
        super.setAttribute(name, value);
    }

    private void setSpecialAttributesToReadonly(String name) {
        if ("firstName".equals(name) || "lastName".equals(name) || "email".equals(name) || "username".equals(name)) {
            throw new ReadOnlyException("Federated storage is not writable");
        }
    }

    public void setEmail(String email) {
        throw new ReadOnlyException("Federated storage is not writable");
    }
}

