/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.collapse;

import org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.apache.lucene.util.BytesRef;
import org.opensearch.neuralsearch.processor.collapse.CollapseDTO;
import org.opensearch.neuralsearch.processor.collapse.CollapseStrategy;

public class CollapseExecutor {
    public int executeCollapse(CollapseDTO collapseDTO) {
        boolean isKeywordCollapse = this.isCollapseOnKeywordField(collapseDTO);
        CollapseStrategy collapseStrategy = isKeywordCollapse ? CollapseStrategy.createKeywordStrategy() : CollapseStrategy.createNumericStrategy();
        collapseStrategy.executeCollapse(collapseDTO);
        return collapseStrategy.getTotalCollapsedDocsCount();
    }

    private boolean isCollapseOnKeywordField(CollapseDTO collapseDTO) {
        return ((CollapseTopFieldDocs)collapseDTO.getCollapseQueryTopDocs().get((int)collapseDTO.getIndexOfFirstNonEmpty()).getTopDocs().getFirst()).collapseValues[0] instanceof BytesRef;
    }
}

