/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.font;

import net.sourceforge.plantuml.klimt.font.UFont;

public enum FontStyle {
    PLAIN,
    ITALIC,
    BOLD,
    UNDERLINE,
    STRIKE,
    WAVE,
    BACKCOLOR;


    public UFont mutateFont(UFont font) {
        if (this == PLAIN) {
            return font.withStyle(0);
        }
        if (this == ITALIC) {
            return font.withStyle(font.getStyle() | 2);
        }
        if (this == BOLD) {
            return font.withStyle(font.getStyle() | 1);
        }
        return font;
    }

    public String getRegexActivationPattern() {
        if (this == PLAIN) {
            return "\\<[pP][lL][aA][iI][nN]\\>";
        }
        if (this == ITALIC) {
            return "\\<[iI]\\>";
        }
        if (this == BOLD) {
            return "\\<[bB]\\>";
        }
        if (this == UNDERLINE) {
            return "\\<[uU](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        if (this == WAVE) {
            return "\\<[wW](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        if (this == BACKCOLOR) {
            return "\\<[bB][aA][cC][kK](?::(#?\\w+(?:[-\\\\|/]#?\\w+)?))?\\>";
        }
        if (this == STRIKE) {
            return "<\u3010strike\u2507STRIKE\u2507s\u2507S\u2507del\u2507DEL\u3011\u3007?\u3018:\u3036$XC=\u3010#\u3007{6}\u300c0\u301c9a\u301cfA\u301cF\u300d\u2507\u3007+\u3034w\u3011\u3019>";
        }
        return null;
    }

    public String getUbrexActivationPattern() {
        if (this == PLAIN) {
            return "<\u300cpP\u300d\u300clL\u300d\u300caA\u300d\u300ciI\u300d\u300cnN\u300d>";
        }
        if (this == ITALIC) {
            return "<\u300ciI\u300d>";
        }
        if (this == BOLD) {
            return "<\u300cbB\u300d>";
        }
        if (this == UNDERLINE) {
            return "<\u300cuU\u300d\u3007?\u3018:\u3036$XC=\u3010#\u3007{6}\u300c0\u301c9a\u301cfA\u301cF\u300d\u2507\u3007+\u3034w\u3011\u3019>";
        }
        if (this == WAVE) {
            return "<\u300cwW\u300d\u3007?\u3018:\u3036$XC=\u3010#\u3007{6}\u300c0\u301c9a\u301cfA\u301cF\u300d\u2507\u3007+\u3034w\u3011\u3019>";
        }
        if (this == BACKCOLOR) {
            return "<\u300cbB\u300d\u300caA\u300d\u300ccC\u300d\u300ckK\u300d\u3007?\u3018:\u3036$XC=\u3018\u3010#\u3007{6}\u300c0\u301c9a\u301cfA\u301cF\u300d\u2507\u3007+\u3034w \u3011 \u3007?\u3018\u300c-\\|/\u300d\u3010\u3007{6}\u300c0\u301c9a\u301cfA\u301cF\u300d\u2507\u3007+\u3034w\u3011 \u3019\u3019 \u3019>";
        }
        if (this == STRIKE) {
            return "<\u3010strike\u2507STRIKE\u2507s\u2507S\u2507del\u2507DEL\u3011\u3007?\u3018:\u3036$XC=\u3010#\u3007{6}\u300c0\u301c9a\u301cfA\u301cF\u300d\u2507\u3007+\u3034w\u3011\u3019>";
        }
        return null;
    }

    public String getUbrexDeactivationPattern() {
        if (this == PLAIN) {
            return "</\u300cpP\u300d\u300clL\u300d\u300caA\u300d\u300ciI\u300d\u300cnN\u300d>";
        }
        if (this == ITALIC) {
            return "</\u300ciI\u300d>";
        }
        if (this == BOLD) {
            return "</\u300cbB\u300d>";
        }
        if (this == UNDERLINE) {
            return "</\u300cuU\u300d>";
        }
        if (this == WAVE) {
            return "</\u300cwW\u300d>";
        }
        if (this == BACKCOLOR) {
            return "</\u300cbB\u300d\u300caA\u300d\u300ccC\u300d\u300ckK\u300d>";
        }
        if (this == STRIKE) {
            return "</\u3010strike\u2507STRIKE\u2507s\u2507S\u2507del\u2507DEL\u3011>";
        }
        return null;
    }

    public String getRegexDeactivationPattern() {
        if (this == PLAIN) {
            return "\\</[pP][lL][aA][iI][nN]\\>";
        }
        if (this == ITALIC) {
            return "\\</[iI]\\>";
        }
        if (this == BOLD) {
            return "\\</[bB]\\>";
        }
        if (this == UNDERLINE) {
            return "\\</[uU]\\>";
        }
        if (this == WAVE) {
            return "\\</[wW]\\>";
        }
        if (this == BACKCOLOR) {
            return "\\</[bB][aA][cC][kK]\\>";
        }
        if (this == STRIKE) {
            return "\\</(?:s|S|strike|STRIKE|del|DEL)\\>";
        }
        return null;
    }

    public boolean canHaveExtendedColor() {
        if (this == UNDERLINE) {
            return true;
        }
        if (this == WAVE) {
            return true;
        }
        if (this == BACKCOLOR) {
            return true;
        }
        return this == STRIKE;
    }

    public String getUbrexCreoleSyntax() {
        if (this == ITALIC) {
            return "//";
        }
        if (this == BOLD) {
            return "**";
        }
        if (this == UNDERLINE) {
            return "__";
        }
        if (this == WAVE) {
            return "~~";
        }
        if (this == STRIKE) {
            return "--";
        }
        throw new UnsupportedOperationException();
    }
}

