/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.alg.mrtree.IGraphImporter;
import org.eclipse.elk.alg.mrtree.graph.TEdge;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class ElkGraphImporter
implements IGraphImporter<ElkNode> {
    @Override
    public TGraph importGraph(ElkNode elkgraph) {
        TGraph tGraph = new TGraph();
        tGraph.copyProperties(elkgraph);
        tGraph.setProperty(InternalProperties.ORIGIN, elkgraph);
        HashMap<ElkNode, TNode> elemMap = new HashMap<ElkNode, TNode>();
        this.transformNodes(elkgraph, tGraph, elemMap);
        this.transformEdges(elkgraph, tGraph, elemMap);
        return tGraph;
    }

    private void transformNodes(ElkNode parentNode, TGraph tGraph, Map<ElkNode, TNode> elemMap) {
        int index = 0;
        for (ElkNode elknode : parentNode.getChildren()) {
            String label = "";
            if (!elknode.getLabels().isEmpty()) {
                label = ((ElkLabel)elknode.getLabels().get(0)).getText();
            }
            TNode newNode = new TNode(index++, tGraph, label);
            newNode.copyProperties(elknode);
            newNode.setProperty(InternalProperties.ORIGIN, elknode);
            newNode.getPosition().y = elknode.getY() + elknode.getHeight() / 2.0;
            newNode.getSize().x = Math.max(elknode.getWidth(), 1.0);
            newNode.getPosition().x = elknode.getX() + elknode.getWidth() / 2.0;
            newNode.getSize().y = Math.max(elknode.getHeight(), 1.0);
            tGraph.getNodes().add(newNode);
            elemMap.put(elknode, newNode);
        }
    }

    private void transformEdges(ElkNode parentNode, TGraph tGraph, Map<ElkNode, TNode> elemMap) {
        for (ElkNode elknode : parentNode.getChildren()) {
            for (ElkEdge elkedge : ElkGraphUtil.allOutgoingEdges(elknode)) {
                if (elkedge.isHierarchical() || elkedge.isHierarchical() || elkedge.isSelfloop()) continue;
                TNode source = elemMap.get(elknode);
                TNode target = elemMap.get(ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getTargets().get(0)));
                if (source == null || target == null) continue;
                TEdge newEdge = new TEdge(source, target);
                newEdge.setProperty(InternalProperties.ORIGIN, elkedge);
                newEdge.copyProperties(elkedge);
                source.getOutgoingEdges().add(newEdge);
                target.getIncomingEdges().add(newEdge);
                tGraph.getEdges().add(newEdge);
            }
        }
    }

    @Override
    public void applyLayout(TGraph tGraph) {
        ElkNode elkgraph = (ElkNode)tGraph.getProperty(InternalProperties.ORIGIN);
        double minXPos = 2.147483647E9;
        double minYPos = 2.147483647E9;
        double maxXPos = -2.147483648E9;
        double maxYPos = -2.147483648E9;
        for (TNode tNode : tGraph.getNodes()) {
            KVector pos = tNode.getPosition();
            KVector size = tNode.getSize();
            minXPos = Math.min(minXPos, pos.x - size.x / 2.0);
            minYPos = Math.min(minYPos, pos.y - size.y / 2.0);
            maxXPos = Math.max(maxXPos, pos.x + size.x / 2.0);
            maxYPos = Math.max(maxYPos, pos.y + size.y / 2.0);
        }
        ElkPadding padding = elkgraph.getProperty(MrTreeOptions.PADDING);
        for (TNode tNode : tGraph.getNodes()) {
            Object object = tNode.getProperty(InternalProperties.ORIGIN);
            if (!(object instanceof ElkNode)) continue;
            ElkNode elknode = (ElkNode)object;
            elknode.setLocation(tNode.getPosition().x, tNode.getPosition().y);
            elknode.copyProperties(tNode);
        }
        for (TEdge tEdge : tGraph.getEdges()) {
            ElkEdge elkedge = (ElkEdge)tEdge.getProperty(InternalProperties.ORIGIN);
            if (elkedge == null) continue;
            KVectorChain bendPoints = tEdge.getBendPoints();
            ElkEdgeSection edgeSection = ElkGraphUtil.firstEdgeSection(elkedge, true, true);
            ElkUtil.applyVectorChain(bendPoints, edgeSection);
        }
        double width = maxXPos - minXPos + padding.getHorizontal();
        double height = maxYPos - minYPos + padding.getVertical();
        if (!elkgraph.getProperty(CoreOptions.NODE_SIZE_FIXED_GRAPH_SIZE).booleanValue()) {
            ElkUtil.resizeNode(elkgraph, width, height, false, false);
        }
        elkgraph.setProperty(CoreOptions.CHILD_AREA_WIDTH, width - padding.getHorizontal());
        elkgraph.setProperty(CoreOptions.CHILD_AREA_HEIGHT, height - padding.getVertical());
    }

    private static void toNodeBorder(KVector center, KVector next, KVector size) {
        double wh = size.x / 2.0;
        double hh = size.y / 2.0;
        double absx = Math.abs(next.x - center.x);
        double absy = Math.abs(next.y - center.y);
        double xscale = 1.0;
        double yscale = 1.0;
        if (absx > wh) {
            xscale = wh / absx;
        }
        if (absy > hh) {
            yscale = hh / absy;
        }
        double scale = Math.min(xscale, yscale);
        center.x += scale * (next.x - center.x);
        center.y += scale * (next.y - center.y);
    }
}

