/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Blacksmith;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.LevelTransition;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.StandardRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.BurningTrap;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.tiles.CustomTilemap;
import com.watabou.noosa.Tilemap;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class BlacksmithRoom
extends StandardRoom {
    @Override
    public int minWidth() {
        return Math.max(super.minWidth(), 6);
    }

    @Override
    public int minHeight() {
        return Math.max(super.minHeight(), 6);
    }

    @Override
    public void paint(Level level) {
        int entrancePos;
        Painter.fill(level, this, 4);
        Painter.fill(level, this, 1, 18);
        for (Room.Door door : this.connected.values()) {
            door.set(Room.Door.Type.REGULAR);
            Painter.drawInside(level, this, door, 2, 1);
        }
        Painter.fill(level, this, 2, 14);
        for (int i = 0; i < 2; ++i) {
            int pos;
            while (level.map[pos = level.pointToCell(this.random())] != 14) {
            }
            level.drop(Generator.random(Random.oneOf(Generator.Category.ARMOR, Generator.Category.WEAPON, Generator.Category.MISSILE)), pos);
        }
        Blacksmith npc = new Blacksmith();
        do {
            npc.pos = level.pointToCell(this.random(2));
        } while (level.heaps.get(npc.pos) != null);
        level.mobs.add(npc);
        do {
            entrancePos = level.pointToCell(this.random(2));
        } while (level.heaps.get(npc.pos) != null || entrancePos == npc.pos);
        QuestEntrance vis = new QuestEntrance();
        vis.pos(entrancePos, level);
        level.customTiles.add(vis);
        level.transitions.add(new LevelTransition(level, entrancePos, LevelTransition.Type.BRANCH_EXIT, Dungeon.depth, Dungeon.branch + 1, LevelTransition.Type.BRANCH_ENTRANCE));
        Painter.set(level, entrancePos, 8);
        for (Point p : this.getPoints()) {
            int cell = level.pointToCell(p);
            if (level.map[cell] != 18) continue;
            level.setTrap(new BurningTrap().reveal(), cell);
        }
    }

    @Override
    public boolean canConnect(Room r) {
        if (r.isExit()) {
            return false;
        }
        return super.canConnect(r);
    }

    @Override
    public boolean canPlaceCharacter(Point p, Level l) {
        if (l.map[l.pointToCell(p)] == 8) {
            return false;
        }
        return super.canPlaceCharacter(p, l);
    }

    public static class QuestEntrance
    extends CustomTilemap {
        public QuestEntrance() {
            this.texture = "environment/custom_tiles/caves_quest.png";
            this.tileH = 1;
            this.tileW = 1;
        }

        @Override
        public Tilemap create() {
            Tilemap v = super.create();
            v.map(new int[]{0}, 1);
            return v;
        }

        @Override
        public String name(int tileX, int tileY) {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc(int tileX, int tileY) {
            return Messages.get(this, "desc", new Object[0]);
        }
    }
}

