﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/gamelift/GameLift_EXPORTS.h>

namespace Aws {
namespace GameLift {
namespace Model {
enum class GameSessionStatusReason { NOT_SET, INTERRUPTED, TRIGGERED_ON_PROCESS_TERMINATE, FORCE_TERMINATED };

namespace GameSessionStatusReasonMapper {
AWS_GAMELIFT_API GameSessionStatusReason GetGameSessionStatusReasonForName(const Aws::String& name);

AWS_GAMELIFT_API Aws::String GetNameForGameSessionStatusReason(GameSessionStatusReason value);
}  // namespace GameSessionStatusReasonMapper
}  // namespace Model
}  // namespace GameLift
}  // namespace Aws
