/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.impl.AssignableImpl;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.FieldGetViaHandle;
import io.quarkus.gizmo2.impl.FieldSet;
import io.quarkus.gizmo2.impl.FieldSetViaHandle;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import java.lang.constant.ClassDesc;
import java.util.function.BiFunction;

public final class FieldDeref
extends AssignableImpl
implements InstanceFieldVar {
    private final Item item;
    private final FieldDesc desc;
    private final GenericType genericType;
    private boolean bound;

    FieldDeref(Item item, FieldDesc desc, GenericType genericType) {
        this.item = item;
        this.desc = desc;
        this.genericType = genericType;
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.item.process(node.prev(), op);
    }

    @Override
    public boolean bound() {
        return this.bound;
    }

    @Override
    protected void bind() {
        if (this.item.bound()) {
            this.bound = true;
        }
    }

    @Override
    public FieldDesc desc() {
        return this.desc;
    }

    @Override
    public ClassDesc type() {
        return this.desc.type();
    }

    @Override
    public GenericType genericType() {
        return this.genericType;
    }

    @Override
    public String itemName() {
        return this.item.itemName() + "." + this.desc.name();
    }

    public Item instance() {
        return this.item;
    }

    @Override
    Item emitGet(BlockCreatorImpl block, MemoryOrder mode) {
        return switch (mode) {
            case MemoryOrder.AsDeclared -> this.asBound();
            default -> new FieldGetViaHandle(this, mode);
        };
    }

    @Override
    Item emitSet(BlockCreatorImpl block, Item value, MemoryOrder mode) {
        return switch (mode) {
            case MemoryOrder.AsDeclared -> new FieldSet(this, value);
            default -> new FieldSetViaHandle(this, value, mode);
        };
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        cb.getfield(this.owner(), this.name(), this.type());
    }
}

