/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.function.Function;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public class ComputeIfAbsentCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    public static final int COMMAND_ID = 69;
    private Function mappingFunction;
    private Metadata metadata;
    private boolean successful = true;
    private PrivateMetadata internalMetadata;

    public ComputeIfAbsentCommand() {
    }

    public ComputeIfAbsentCommand(Object key, Function mappingFunction, int segment, long flagsBitSet, CommandInvocationId commandInvocationId, Metadata metadata) {
        super(key, segment, flagsBitSet, commandInvocationId);
        this.mappingFunction = mappingFunction;
        this.metadata = metadata;
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.mappingFunction);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    public Function getMappingFunction() {
        return this.mappingFunction;
    }

    @Override
    public byte getCommandId() {
        return 69;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.mappingFunction);
        UnsignedNumeric.writeUnsignedInt((DataOutput)output, (int)this.segment);
        output.writeObject(this.metadata);
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeObject(this.internalMetadata);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.mappingFunction = (Function)input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt((DataInput)input);
        this.metadata = (Metadata)input.readObject();
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.setFlagsBitSet(input.readLong());
        this.internalMetadata = (PrivateMetadata)input.readObject();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitComputeIfAbsentCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComputeIfAbsentCommand that = (ComputeIfAbsentCommand)o;
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.mappingFunction, that.mappingFunction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mappingFunction, this.metadata);
    }

    @Override
    public String toString() {
        return "ComputeIfAbsentCommand{key=" + Util.toStr((Object)this.key) + ", mappingFunction=" + Util.toStr((Object)this.mappingFunction) + ", metadata=" + String.valueOf(this.metadata) + ", flags=" + this.printFlags() + ", successful=" + this.isSuccessful() + ", valueMatcher=" + String.valueOf((Object)this.getValueMatcher()) + ", topologyId=" + this.getTopologyId() + "}";
    }

    @Override
    public final boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public PrivateMetadata getInternalMetadata() {
        return this.internalMetadata;
    }

    @Override
    public void setInternalMetadata(PrivateMetadata internalMetadata) {
        this.internalMetadata = internalMetadata;
    }
}

