/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.client.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.impl.BaseQueryResponse;

public class JsonClientQueryResponse
implements BaseQueryResponse<String> {
    private static final String JSON_HITS = "hits";
    private static final String JSON_HIT = "hit";
    private static final String JSON_HIT_COUNT = "hit_count";
    private static final String JSON_HIT_COUNT_EXACT = "hit_count_exact";
    private final Json jsonObject;

    public JsonClientQueryResponse(Json jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public List<String> extractResults(SerializationContext serializationContext) {
        return this.jsonObject.at(JSON_HITS).asJsonList().stream().map(j -> j.at(JSON_HIT).toString()).collect(Collectors.toList());
    }

    @Override
    public int hitCount() {
        return this.jsonObject.at(JSON_HIT_COUNT).asInteger();
    }

    @Override
    public boolean hitCountExact() {
        return this.jsonObject.at(JSON_HIT_COUNT_EXACT).asBoolean();
    }
}

