/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.lucene.store.RandomAccessInput;
import org.opensearch.common.util.ByteArrayBackedBitset;

public class StarTreeDocumentBitSetUtil {
    public static int readBitSet(RandomAccessInput input, long offset, Object[] array, Function<Integer, Object> identityValueSupplier) throws IOException {
        ByteArrayBackedBitset bitset = new ByteArrayBackedBitset(input, offset, StarTreeDocumentBitSetUtil.getLength(array));
        for (int i = 0; i < array.length; ++i) {
            if (!bitset.get(i)) continue;
            array[i] = identityValueSupplier.apply(i);
        }
        return bitset.getCurrBytesRead();
    }

    public static void writeBitSet(Object[] array, ByteBuffer buffer) throws IOException {
        ByteArrayBackedBitset bitset = new ByteArrayBackedBitset(StarTreeDocumentBitSetUtil.getLength(array));
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            bitset.set(i);
        }
        bitset.write(buffer);
    }

    private static int getLength(Object[] array) {
        return array.length / 8 + (array.length % 8 == 0 ? 0 : 1);
    }
}

