/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.CloudError;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementClientImpl;
import com.microsoft.windowsazure.management.compute.VirtualMachineVMImageOperations;
import com.microsoft.windowsazure.management.compute.models.ComputeImageAttributes;
import com.microsoft.windowsazure.management.compute.models.DataDiskConfigurationCreateParameters;
import com.microsoft.windowsazure.management.compute.models.DataDiskConfigurationUpdateParameters;
import com.microsoft.windowsazure.management.compute.models.MarketplaceImageAttributes;
import com.microsoft.windowsazure.management.compute.models.Plan;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineVMImageCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineVMImageGetDetailsResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineVMImageListResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineVMImageReplicateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineVMImageReplicateResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineVMImageUpdateParameters;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class VirtualMachineVMImageOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
VirtualMachineVMImageOperations {
    private ComputeManagementClientImpl client;

    VirtualMachineVMImageOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationResponse> beginCreatingAsync(final VirtualMachineVMImageCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.beginCreating(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginCreating(VirtualMachineVMImageCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDataDiskConfigurations() != null) {
            for (DataDiskConfigurationCreateParameters dataDiskConfigurationsParameterItem : parameters.getDataDiskConfigurations()) {
                if (dataDiskConfigurationsParameterItem.getMediaLink() != null) continue;
                throw new NullPointerException("parameters.DataDiskConfigurations.MediaLink");
            }
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        if (parameters.getOSDiskConfiguration() == null) {
            throw new NullPointerException("parameters.OSDiskConfiguration");
        }
        if (parameters.getOSDiskConfiguration().getMediaLink() == null) {
            throw new NullPointerException("parameters.OSDiskConfiguration.MediaLink");
        }
        if (parameters.getOSDiskConfiguration().getOS() == null) {
            throw new NullPointerException("parameters.OSDiskConfiguration.OS");
        }
        if (parameters.getOSDiskConfiguration().getOSState() == null) {
            throw new NullPointerException("parameters.OSDiskConfiguration.OSState");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, VirtualMachineVMImageCreateParameters> tracingParameters = new HashMap<String, VirtualMachineVMImageCreateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/vmimages";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element vMImageElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VMImage");
        requestDoc.appendChild(vMImageElement);
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        vMImageElement.appendChild(nameElement);
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
        vMImageElement.appendChild(labelElement);
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            vMImageElement.appendChild(descriptionElement);
        }
        Element oSDiskConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OSDiskConfiguration");
        vMImageElement.appendChild(oSDiskConfigurationElement);
        if (parameters.getOSDiskConfiguration().getHostCaching() != null) {
            Element hostCachingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
            hostCachingElement.appendChild(requestDoc.createTextNode(parameters.getOSDiskConfiguration().getHostCaching()));
            oSDiskConfigurationElement.appendChild(hostCachingElement);
        }
        Element oSStateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OSState");
        oSStateElement.appendChild(requestDoc.createTextNode(parameters.getOSDiskConfiguration().getOSState()));
        oSDiskConfigurationElement.appendChild(oSStateElement);
        Element osElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OS");
        osElement.appendChild(requestDoc.createTextNode(parameters.getOSDiskConfiguration().getOS()));
        oSDiskConfigurationElement.appendChild(osElement);
        Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
        mediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getOSDiskConfiguration().getMediaLink().toString()));
        oSDiskConfigurationElement.appendChild(mediaLinkElement);
        if (parameters.getDataDiskConfigurations() != null && (!(parameters.getDataDiskConfigurations() instanceof LazyCollection) || ((LazyCollection)parameters.getDataDiskConfigurations()).isInitialized())) {
            Element dataDiskConfigurationsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataDiskConfigurations");
            for (DataDiskConfigurationCreateParameters dataDiskConfigurationsItem : parameters.getDataDiskConfigurations()) {
                Element dataDiskConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataDiskConfiguration");
                dataDiskConfigurationsSequenceElement.appendChild(dataDiskConfigurationElement);
                if (dataDiskConfigurationsItem.getHostCaching() != null) {
                    Element hostCachingElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
                    hostCachingElement2.appendChild(requestDoc.createTextNode(dataDiskConfigurationsItem.getHostCaching()));
                    dataDiskConfigurationElement.appendChild(hostCachingElement2);
                }
                if (dataDiskConfigurationsItem.getLogicalUnitNumber() != null) {
                    Element lunElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Lun");
                    lunElement.appendChild(requestDoc.createTextNode(Integer.toString(dataDiskConfigurationsItem.getLogicalUnitNumber())));
                    dataDiskConfigurationElement.appendChild(lunElement);
                }
                Element mediaLinkElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
                mediaLinkElement2.appendChild(requestDoc.createTextNode(dataDiskConfigurationsItem.getMediaLink().toString()));
                dataDiskConfigurationElement.appendChild(mediaLinkElement2);
            }
            vMImageElement.appendChild(dataDiskConfigurationsSequenceElement);
        }
        if (parameters.getLanguage() != null) {
            Element languageElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Language");
            languageElement.appendChild(requestDoc.createTextNode(parameters.getLanguage()));
            vMImageElement.appendChild(languageElement);
        }
        if (parameters.getImageFamily() != null) {
            Element imageFamilyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ImageFamily");
            imageFamilyElement.appendChild(requestDoc.createTextNode(parameters.getImageFamily()));
            vMImageElement.appendChild(imageFamilyElement);
        }
        if (parameters.getRecommendedVMSize() != null) {
            Element recommendedVMSizeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RecommendedVMSize");
            recommendedVMSizeElement.appendChild(requestDoc.createTextNode(parameters.getRecommendedVMSize()));
            vMImageElement.appendChild(recommendedVMSizeElement);
        }
        if (parameters.getEula() != null) {
            Element eulaElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Eula");
            eulaElement.appendChild(requestDoc.createTextNode(parameters.getEula()));
            vMImageElement.appendChild(eulaElement);
        }
        if (parameters.getIconUri() != null) {
            Element iconUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IconUri");
            iconUriElement.appendChild(requestDoc.createTextNode(parameters.getIconUri()));
            vMImageElement.appendChild(iconUriElement);
        }
        if (parameters.getSmallIconUri() != null) {
            Element smallIconUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SmallIconUri");
            smallIconUriElement.appendChild(requestDoc.createTextNode(parameters.getSmallIconUri()));
            vMImageElement.appendChild(smallIconUriElement);
        }
        if (parameters.getPrivacyUri() != null) {
            Element privacyUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PrivacyUri");
            privacyUriElement.appendChild(requestDoc.createTextNode(parameters.getPrivacyUri().toString()));
            vMImageElement.appendChild(privacyUriElement);
        }
        if (parameters.getPublishedDate() != null) {
            Element publishedDateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublishedDate");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            publishedDateElement.appendChild(requestDoc.createTextNode(simpleDateFormat.format(parameters.getPublishedDate().getTime())));
            vMImageElement.appendChild(publishedDateElement);
        }
        if (parameters.isShowInGui() != null) {
            Element showInGuiElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ShowInGui");
            showInGuiElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isShowInGui()).toLowerCase()));
            vMImageElement.appendChild(showInGuiElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginDeletingAsync(final String vmImageName, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.beginDeleting(vmImageName, deleteFromStorage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeleting(String vmImageName, boolean deleteFromStorage) throws IOException, ServiceException {
        String baseUrl;
        if (vmImageName == null) {
            throw new NullPointerException("vmImageName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vmImageName", vmImageName);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/vmimages/";
        url = url + URLEncoder.encode(vmImageName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        if (deleteFromStorage) {
            queryParameters.add("comp=media");
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginSharingAsync(final String vmImageName, final String permission) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.beginSharing(vmImageName, permission);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginSharing(String vmImageName, String permission) throws IOException, ServiceException {
        String baseUrl;
        if (vmImageName == null) {
            throw new NullPointerException("vmImageName");
        }
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("vmImageName", vmImageName);
            tracingParameters.put("permission", permission);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginSharingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/vmimages/";
        url = url + URLEncoder.encode(vmImageName, "UTF-8");
        url = url + "/shareasync";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("permission=" + URLEncoder.encode(permission, "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginUnreplicatingAsync(final String vmImageName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.beginUnreplicating(vmImageName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginUnreplicating(String vmImageName) throws IOException, ServiceException {
        if (vmImageName == null) {
            throw new NullPointerException("vmImageName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("vmImageName", vmImageName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginUnreplicatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/vmimages/";
        url = url + URLEncoder.encode(vmImageName, "UTF-8");
        url = url + "/unreplicate";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> createAsync(final VirtualMachineVMImageCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.create(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse create(VirtualMachineVMImageCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, VirtualMachineVMImageCreateParameters> tracingParameters = new HashMap<String, VirtualMachineVMImageCreateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachineVMImagesOperations().beginCreatingAsync(parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteAsync(final String vmImageName, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.delete(vmImageName, deleteFromStorage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse delete(String vmImageName, boolean deleteFromStorage) throws IOException, ServiceException, InterruptedException, ExecutionException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vmImageName", vmImageName);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachineVMImagesOperations().beginDeletingAsync(vmImageName, deleteFromStorage).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<VirtualMachineVMImageGetDetailsResponse> getDetailsAsync(final String vmImageName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineVMImageGetDetailsResponse>(){

            @Override
            public VirtualMachineVMImageGetDetailsResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.getDetails(vmImageName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineVMImageGetDetailsResponse getDetails(String vmImageName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (vmImageName == null) {
            throw new NullPointerException("vmImageName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("vmImageName", vmImageName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getDetailsAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/vmimages/";
        url = url + URLEncoder.encode(vmImageName, "UTF-8");
        url = url + "/details";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineVMImageGetDetailsResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineVMImageGetDetailsResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element vMImageDetailsElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"VMImageDetails");
                if (vMImageDetailsElement != null) {
                    Element marketplaceImageAttributesElement;
                    Element computeImageAttributesElement;
                    Element replicationProgressSequenceElement;
                    Element sharingStatusElement;
                    Element publishedNameElement;
                    Element isCorruptedElement;
                    Element pricingDetailLinkElement;
                    Element showInGuiElement;
                    Element publishedDateElement;
                    Element publisherNameElement;
                    Element privacyUriElement;
                    Element smallIconUriElement;
                    Element iconUriElement;
                    Element eulaElement;
                    Element isPremiumElement;
                    Element recommendedVMSizeElement;
                    Element imageFamilyElement;
                    Element languageElement;
                    Element modifiedTimeElement;
                    Element createdTimeElement;
                    Element locationElement;
                    Element affinityGroupElement;
                    Element roleNameElement;
                    Element deploymentNameElement;
                    Element serviceNameElement;
                    Element dataDiskConfigurationsSequenceElement;
                    Element oSDiskConfigurationElement;
                    Element descriptionElement;
                    Element categoryElement;
                    Element labelElement;
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        result.setName(nameInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent();
                        result.setLabel(labelInstance);
                    }
                    if ((categoryElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Category")) != null) {
                        String categoryInstance = categoryElement.getTextContent();
                        result.setCategory(categoryInstance);
                    }
                    if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                        String descriptionInstance = descriptionElement.getTextContent();
                        result.setDescription(descriptionInstance);
                    }
                    if ((oSDiskConfigurationElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSDiskConfiguration")) != null) {
                        Element iOTypeElement;
                        Element logicalDiskSizeInGBElement;
                        Element mediaLinkElement;
                        Element osElement;
                        Element oSStateElement;
                        Element hostCachingElement;
                        VirtualMachineVMImageListResponse.OSDiskConfiguration oSDiskConfigurationInstance = new VirtualMachineVMImageListResponse.OSDiskConfiguration();
                        result.setOSDiskConfiguration(oSDiskConfigurationInstance);
                        Element nameElement2 = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                        if (nameElement2 != null) {
                            String nameInstance2 = nameElement2.getTextContent();
                            oSDiskConfigurationInstance.setName(nameInstance2);
                        }
                        if ((hostCachingElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching")) != null) {
                            String hostCachingInstance = hostCachingElement.getTextContent();
                            oSDiskConfigurationInstance.setHostCaching(hostCachingInstance);
                        }
                        if ((oSStateElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSState")) != null) {
                            String oSStateInstance = oSStateElement.getTextContent();
                            oSDiskConfigurationInstance.setOSState(oSStateInstance);
                        }
                        if ((osElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                            String osInstance = osElement.getTextContent();
                            oSDiskConfigurationInstance.setOperatingSystem(osInstance);
                        }
                        if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                            URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                            oSDiskConfigurationInstance.setMediaLink(mediaLinkInstance);
                        }
                        if ((logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null) {
                            int logicalDiskSizeInGBInstance = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement.getTextContent());
                            oSDiskConfigurationInstance.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance);
                        }
                        if ((iOTypeElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) != null) {
                            String iOTypeInstance = iOTypeElement.getTextContent();
                            oSDiskConfigurationInstance.setIOType(iOTypeInstance);
                        }
                    }
                    if ((dataDiskConfigurationsSequenceElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfigurations")) != null) {
                        for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)dataDiskConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfiguration").size(); ++i1) {
                            Element iOTypeElement2;
                            Element logicalDiskSizeInGBElement2;
                            Element mediaLinkElement2;
                            Element lunElement;
                            Element hostCachingElement2;
                            Element dataDiskConfigurationsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dataDiskConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfiguration").get(i1);
                            VirtualMachineVMImageListResponse.DataDiskConfiguration dataDiskConfigurationInstance = new VirtualMachineVMImageListResponse.DataDiskConfiguration();
                            result.getDataDiskConfigurations().add(dataDiskConfigurationInstance);
                            Element nameElement3 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                            if (nameElement3 != null) {
                                String nameInstance3 = nameElement3.getTextContent();
                                dataDiskConfigurationInstance.setName(nameInstance3);
                            }
                            if ((hostCachingElement2 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching")) != null) {
                                String hostCachingInstance2 = hostCachingElement2.getTextContent();
                                dataDiskConfigurationInstance.setHostCaching(hostCachingInstance2);
                            }
                            if ((lunElement = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Lun")) != null && lunElement.getTextContent() != null && !lunElement.getTextContent().isEmpty()) {
                                int lunInstance = DatatypeConverter.parseInt((String)lunElement.getTextContent());
                                dataDiskConfigurationInstance.setLogicalUnitNumber(lunInstance);
                            }
                            if ((mediaLinkElement2 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                                URI mediaLinkInstance2 = new URI(mediaLinkElement2.getTextContent());
                                dataDiskConfigurationInstance.setMediaLink(mediaLinkInstance2);
                            }
                            if ((logicalDiskSizeInGBElement2 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null) {
                                int logicalDiskSizeInGBInstance2 = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement2.getTextContent());
                                dataDiskConfigurationInstance.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance2);
                            }
                            if ((iOTypeElement2 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) == null) continue;
                            String iOTypeInstance2 = iOTypeElement2.getTextContent();
                            dataDiskConfigurationInstance.setIOType(iOTypeInstance2);
                        }
                    }
                    if ((serviceNameElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceName")) != null) {
                        String serviceNameInstance = serviceNameElement.getTextContent();
                        result.setServiceName(serviceNameInstance);
                    }
                    if ((deploymentNameElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentName")) != null) {
                        String deploymentNameInstance = deploymentNameElement.getTextContent();
                        result.setDeploymentName(deploymentNameInstance);
                    }
                    if ((roleNameElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName")) != null) {
                        String roleNameInstance = roleNameElement.getTextContent();
                        result.setRoleName(roleNameInstance);
                    }
                    if ((affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup")) != null) {
                        String affinityGroupInstance = affinityGroupElement.getTextContent();
                        result.setAffinityGroup(affinityGroupInstance);
                    }
                    if ((locationElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                        String locationInstance = locationElement.getTextContent();
                        result.setLocation(locationInstance);
                    }
                    if ((createdTimeElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CreatedTime")) != null && createdTimeElement.getTextContent() != null && !createdTimeElement.getTextContent().isEmpty()) {
                        Calendar createdTimeInstance = DatatypeConverter.parseDateTime((String)createdTimeElement.getTextContent());
                        result.setCreatedTime(createdTimeInstance);
                    }
                    if ((modifiedTimeElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ModifiedTime")) != null && modifiedTimeElement.getTextContent() != null && !modifiedTimeElement.getTextContent().isEmpty()) {
                        Calendar modifiedTimeInstance = DatatypeConverter.parseDateTime((String)modifiedTimeElement.getTextContent());
                        result.setModifiedTime(modifiedTimeInstance);
                    }
                    if ((languageElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language")) != null) {
                        String languageInstance = languageElement.getTextContent();
                        result.setLanguage(languageInstance);
                    }
                    if ((imageFamilyElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ImageFamily")) != null) {
                        String imageFamilyInstance = imageFamilyElement.getTextContent();
                        result.setImageFamily(imageFamilyInstance);
                    }
                    if ((recommendedVMSizeElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RecommendedVMSize")) != null) {
                        String recommendedVMSizeInstance = recommendedVMSizeElement.getTextContent();
                        result.setRecommendedVMSize(recommendedVMSizeInstance);
                    }
                    if ((isPremiumElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsPremium")) != null && isPremiumElement.getTextContent() != null && !isPremiumElement.getTextContent().isEmpty()) {
                        boolean isPremiumInstance = DatatypeConverter.parseBoolean((String)isPremiumElement.getTextContent().toLowerCase());
                        result.setIsPremium(isPremiumInstance);
                    }
                    if ((eulaElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Eula")) != null) {
                        String eulaInstance = eulaElement.getTextContent();
                        result.setEula(eulaInstance);
                    }
                    if ((iconUriElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IconUri")) != null) {
                        String iconUriInstance = iconUriElement.getTextContent();
                        result.setIconUri(iconUriInstance);
                    }
                    if ((smallIconUriElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SmallIconUri")) != null) {
                        String smallIconUriInstance = smallIconUriElement.getTextContent();
                        result.setSmallIconUri(smallIconUriInstance);
                    }
                    if ((privacyUriElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivacyUri")) != null) {
                        URI privacyUriInstance = new URI(privacyUriElement.getTextContent());
                        result.setPrivacyUri(privacyUriInstance);
                    }
                    if ((publisherNameElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublisherName")) != null) {
                        String publisherNameInstance = publisherNameElement.getTextContent();
                        result.setPublisherName(publisherNameInstance);
                    }
                    if ((publishedDateElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublishedDate")) != null && publishedDateElement.getTextContent() != null && !publishedDateElement.getTextContent().isEmpty()) {
                        Calendar publishedDateInstance = DatatypeConverter.parseDateTime((String)publishedDateElement.getTextContent());
                        result.setPublishedDate(publishedDateInstance);
                    }
                    if ((showInGuiElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ShowInGui")) != null && showInGuiElement.getTextContent() != null && !showInGuiElement.getTextContent().isEmpty()) {
                        boolean showInGuiInstance = DatatypeConverter.parseBoolean((String)showInGuiElement.getTextContent().toLowerCase());
                        result.setShowInGui(showInGuiInstance);
                    }
                    if ((pricingDetailLinkElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PricingDetailLink")) != null) {
                        URI pricingDetailLinkInstance = new URI(pricingDetailLinkElement.getTextContent());
                        result.setPricingDetailLink(pricingDetailLinkInstance);
                    }
                    if ((isCorruptedElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsCorrupted")) != null && isCorruptedElement.getTextContent() != null && !isCorruptedElement.getTextContent().isEmpty()) {
                        boolean isCorruptedInstance = DatatypeConverter.parseBoolean((String)isCorruptedElement.getTextContent().toLowerCase());
                        result.setIsCorrupted(isCorruptedInstance);
                    }
                    if ((publishedNameElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublishedName")) != null) {
                        String publishedNameInstance = publishedNameElement.getTextContent();
                        result.setPublishedName(publishedNameInstance);
                    }
                    if ((sharingStatusElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SharingStatus")) != null) {
                        String sharingStatusInstance = sharingStatusElement.getTextContent();
                        result.setSharingStatus(sharingStatusInstance);
                    }
                    if ((replicationProgressSequenceElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationProgress")) != null) {
                        for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)replicationProgressSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationProgressElement").size(); ++i2) {
                            Element progressElement;
                            Element replicationProgressElement = (Element)XmlUtility.getElementsByTagNameNS((Node)replicationProgressSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationProgressElement").get(i2);
                            VirtualMachineVMImageGetDetailsResponse.ReplicationProgressElement replicationProgressElementInstance = new VirtualMachineVMImageGetDetailsResponse.ReplicationProgressElement();
                            result.getReplicationProgress().add(replicationProgressElementInstance);
                            Element locationElement2 = XmlUtility.getElementByTagNameNS((Node)replicationProgressElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location");
                            if (locationElement2 != null) {
                                String locationInstance2 = locationElement2.getTextContent();
                                replicationProgressElementInstance.setLocation(locationInstance2);
                            }
                            if ((progressElement = XmlUtility.getElementByTagNameNS((Node)replicationProgressElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Progress")) == null) continue;
                            String progressInstance = progressElement.getTextContent();
                            replicationProgressElementInstance.setProgress(progressInstance);
                        }
                    }
                    if ((computeImageAttributesElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComputeImageAttributes")) != null) {
                        Element versionElement;
                        Element skuElement;
                        ComputeImageAttributes computeImageAttributesInstance = new ComputeImageAttributes();
                        result.setComputeImageAttributes(computeImageAttributesInstance);
                        Element offerElement = XmlUtility.getElementByTagNameNS((Node)computeImageAttributesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Offer");
                        if (offerElement != null) {
                            String offerInstance = offerElement.getTextContent();
                            computeImageAttributesInstance.setOffer(offerInstance);
                        }
                        if ((skuElement = XmlUtility.getElementByTagNameNS((Node)computeImageAttributesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Sku")) != null) {
                            String skuInstance = skuElement.getTextContent();
                            computeImageAttributesInstance.setSku(skuInstance);
                        }
                        if ((versionElement = XmlUtility.getElementByTagNameNS((Node)computeImageAttributesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                            String versionInstance = versionElement.getTextContent();
                            computeImageAttributesInstance.setVersion(versionInstance);
                        }
                    }
                    if ((marketplaceImageAttributesElement = XmlUtility.getElementByTagNameNS((Node)vMImageDetailsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MarketplaceImageAttributes")) != null) {
                        Element planElement;
                        MarketplaceImageAttributes marketplaceImageAttributesInstance = new MarketplaceImageAttributes();
                        result.setMarketplaceImageAttributes(marketplaceImageAttributesInstance);
                        Element publisherIdElement = XmlUtility.getElementByTagNameNS((Node)marketplaceImageAttributesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublisherId");
                        if (publisherIdElement != null) {
                            String publisherIdInstance = publisherIdElement.getTextContent();
                            marketplaceImageAttributesInstance.setPublisherId(publisherIdInstance);
                        }
                        if ((planElement = XmlUtility.getElementByTagNameNS((Node)marketplaceImageAttributesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Plan")) != null) {
                            Element productElement;
                            Element publisherElement;
                            Plan planInstance = new Plan();
                            marketplaceImageAttributesInstance.setPlan(planInstance);
                            Element nameElement4 = XmlUtility.getElementByTagNameNS((Node)planElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                            if (nameElement4 != null) {
                                String nameInstance4 = nameElement4.getTextContent();
                                planInstance.setName(nameInstance4);
                            }
                            if ((publisherElement = XmlUtility.getElementByTagNameNS((Node)planElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Publisher")) != null) {
                                String publisherInstance = publisherElement.getTextContent();
                                planInstance.setPublisher(publisherInstance);
                            }
                            if ((productElement = XmlUtility.getElementByTagNameNS((Node)planElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Product")) != null) {
                                String productInstance = productElement.getTextContent();
                                planInstance.setProduct(productInstance);
                            }
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineVMImageGetDetailsResponse virtualMachineVMImageGetDetailsResponse = result;
            return virtualMachineVMImageGetDetailsResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineVMImageListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineVMImageListResponse>(){

            @Override
            public VirtualMachineVMImageListResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineVMImageListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/vmimages";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineVMImageListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineVMImageListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element vMImagesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"VMImages");
                if (vMImagesSequenceElement != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)vMImagesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VMImage").size(); ++i1) {
                        Element pricingDetailLinkElement;
                        Element showInGuiElement;
                        Element publishedDateElement;
                        Element publisherNameElement;
                        Element privacyUriElement;
                        Element smallIconUriElement;
                        Element iconUriElement;
                        Element eulaElement;
                        Element isPremiumElement;
                        Element recommendedVMSizeElement;
                        Element imageFamilyElement;
                        Element languageElement;
                        Element modifiedTimeElement;
                        Element createdTimeElement;
                        Element locationElement;
                        Element affinityGroupElement;
                        Element roleNameElement;
                        Element deploymentNameElement;
                        Element serviceNameElement;
                        Element dataDiskConfigurationsSequenceElement;
                        Element oSDiskConfigurationElement;
                        Element descriptionElement;
                        Element categoryElement;
                        Element labelElement;
                        Element vMImagesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)vMImagesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VMImage").get(i1);
                        VirtualMachineVMImageListResponse.VirtualMachineVMImage vMImageInstance = new VirtualMachineVMImageListResponse.VirtualMachineVMImage();
                        result.getVMImages().add(vMImageInstance);
                        Element nameElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                        if (nameElement != null) {
                            String nameInstance = nameElement.getTextContent();
                            vMImageInstance.setName(nameInstance);
                        }
                        if ((labelElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                            String labelInstance = labelElement.getTextContent();
                            vMImageInstance.setLabel(labelInstance);
                        }
                        if ((categoryElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Category")) != null) {
                            String categoryInstance = categoryElement.getTextContent();
                            vMImageInstance.setCategory(categoryInstance);
                        }
                        if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                            String descriptionInstance = descriptionElement.getTextContent();
                            vMImageInstance.setDescription(descriptionInstance);
                        }
                        if ((oSDiskConfigurationElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSDiskConfiguration")) != null) {
                            Element iOTypeElement;
                            Element logicalDiskSizeInGBElement;
                            Element mediaLinkElement;
                            Element osElement;
                            Element oSStateElement;
                            Element hostCachingElement;
                            VirtualMachineVMImageListResponse.OSDiskConfiguration oSDiskConfigurationInstance = new VirtualMachineVMImageListResponse.OSDiskConfiguration();
                            vMImageInstance.setOSDiskConfiguration(oSDiskConfigurationInstance);
                            Element nameElement2 = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                            if (nameElement2 != null) {
                                String nameInstance2 = nameElement2.getTextContent();
                                oSDiskConfigurationInstance.setName(nameInstance2);
                            }
                            if ((hostCachingElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching")) != null) {
                                String hostCachingInstance = hostCachingElement.getTextContent();
                                oSDiskConfigurationInstance.setHostCaching(hostCachingInstance);
                            }
                            if ((oSStateElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSState")) != null) {
                                String oSStateInstance = oSStateElement.getTextContent();
                                oSDiskConfigurationInstance.setOSState(oSStateInstance);
                            }
                            if ((osElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                                String osInstance = osElement.getTextContent();
                                oSDiskConfigurationInstance.setOperatingSystem(osInstance);
                            }
                            if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                                URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                                oSDiskConfigurationInstance.setMediaLink(mediaLinkInstance);
                            }
                            if ((logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null) {
                                int logicalDiskSizeInGBInstance = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement.getTextContent());
                                oSDiskConfigurationInstance.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance);
                            }
                            if ((iOTypeElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) != null) {
                                String iOTypeInstance = iOTypeElement.getTextContent();
                                oSDiskConfigurationInstance.setIOType(iOTypeInstance);
                            }
                        }
                        if ((dataDiskConfigurationsSequenceElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfigurations")) != null) {
                            for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)dataDiskConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfiguration").size(); ++i2) {
                                Element iOTypeElement2;
                                Element logicalDiskSizeInGBElement2;
                                Element mediaLinkElement2;
                                Element lunElement;
                                Element hostCachingElement2;
                                Element dataDiskConfigurationsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dataDiskConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfiguration").get(i2);
                                VirtualMachineVMImageListResponse.DataDiskConfiguration dataDiskConfigurationInstance = new VirtualMachineVMImageListResponse.DataDiskConfiguration();
                                vMImageInstance.getDataDiskConfigurations().add(dataDiskConfigurationInstance);
                                Element nameElement3 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                if (nameElement3 != null) {
                                    String nameInstance3 = nameElement3.getTextContent();
                                    dataDiskConfigurationInstance.setName(nameInstance3);
                                }
                                if ((hostCachingElement2 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching")) != null) {
                                    String hostCachingInstance2 = hostCachingElement2.getTextContent();
                                    dataDiskConfigurationInstance.setHostCaching(hostCachingInstance2);
                                }
                                if ((lunElement = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Lun")) != null && lunElement.getTextContent() != null && !lunElement.getTextContent().isEmpty()) {
                                    int lunInstance = DatatypeConverter.parseInt((String)lunElement.getTextContent());
                                    dataDiskConfigurationInstance.setLogicalUnitNumber(lunInstance);
                                }
                                if ((mediaLinkElement2 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                                    URI mediaLinkInstance2 = new URI(mediaLinkElement2.getTextContent());
                                    dataDiskConfigurationInstance.setMediaLink(mediaLinkInstance2);
                                }
                                if ((logicalDiskSizeInGBElement2 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null) {
                                    int logicalDiskSizeInGBInstance2 = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement2.getTextContent());
                                    dataDiskConfigurationInstance.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance2);
                                }
                                if ((iOTypeElement2 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) == null) continue;
                                String iOTypeInstance2 = iOTypeElement2.getTextContent();
                                dataDiskConfigurationInstance.setIOType(iOTypeInstance2);
                            }
                        }
                        if ((serviceNameElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceName")) != null) {
                            String serviceNameInstance = serviceNameElement.getTextContent();
                            vMImageInstance.setServiceName(serviceNameInstance);
                        }
                        if ((deploymentNameElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentName")) != null) {
                            String deploymentNameInstance = deploymentNameElement.getTextContent();
                            vMImageInstance.setDeploymentName(deploymentNameInstance);
                        }
                        if ((roleNameElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName")) != null) {
                            String roleNameInstance = roleNameElement.getTextContent();
                            vMImageInstance.setRoleName(roleNameInstance);
                        }
                        if ((affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup")) != null) {
                            String affinityGroupInstance = affinityGroupElement.getTextContent();
                            vMImageInstance.setAffinityGroup(affinityGroupInstance);
                        }
                        if ((locationElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                            String locationInstance = locationElement.getTextContent();
                            vMImageInstance.setLocation(locationInstance);
                        }
                        if ((createdTimeElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CreatedTime")) != null && createdTimeElement.getTextContent() != null && !createdTimeElement.getTextContent().isEmpty()) {
                            Calendar createdTimeInstance = DatatypeConverter.parseDateTime((String)createdTimeElement.getTextContent());
                            vMImageInstance.setCreatedTime(createdTimeInstance);
                        }
                        if ((modifiedTimeElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ModifiedTime")) != null && modifiedTimeElement.getTextContent() != null && !modifiedTimeElement.getTextContent().isEmpty()) {
                            Calendar modifiedTimeInstance = DatatypeConverter.parseDateTime((String)modifiedTimeElement.getTextContent());
                            vMImageInstance.setModifiedTime(modifiedTimeInstance);
                        }
                        if ((languageElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language")) != null) {
                            String languageInstance = languageElement.getTextContent();
                            vMImageInstance.setLanguage(languageInstance);
                        }
                        if ((imageFamilyElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ImageFamily")) != null) {
                            String imageFamilyInstance = imageFamilyElement.getTextContent();
                            vMImageInstance.setImageFamily(imageFamilyInstance);
                        }
                        if ((recommendedVMSizeElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RecommendedVMSize")) != null) {
                            String recommendedVMSizeInstance = recommendedVMSizeElement.getTextContent();
                            vMImageInstance.setRecommendedVMSize(recommendedVMSizeInstance);
                        }
                        if ((isPremiumElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsPremium")) != null && isPremiumElement.getTextContent() != null && !isPremiumElement.getTextContent().isEmpty()) {
                            boolean isPremiumInstance = DatatypeConverter.parseBoolean((String)isPremiumElement.getTextContent().toLowerCase());
                            vMImageInstance.setIsPremium(isPremiumInstance);
                        }
                        if ((eulaElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Eula")) != null) {
                            String eulaInstance = eulaElement.getTextContent();
                            vMImageInstance.setEula(eulaInstance);
                        }
                        if ((iconUriElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IconUri")) != null) {
                            String iconUriInstance = iconUriElement.getTextContent();
                            vMImageInstance.setIconUri(iconUriInstance);
                        }
                        if ((smallIconUriElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SmallIconUri")) != null) {
                            String smallIconUriInstance = smallIconUriElement.getTextContent();
                            vMImageInstance.setSmallIconUri(smallIconUriInstance);
                        }
                        if ((privacyUriElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivacyUri")) != null) {
                            URI privacyUriInstance = new URI(privacyUriElement.getTextContent());
                            vMImageInstance.setPrivacyUri(privacyUriInstance);
                        }
                        if ((publisherNameElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublisherName")) != null) {
                            String publisherNameInstance = publisherNameElement.getTextContent();
                            vMImageInstance.setPublisherName(publisherNameInstance);
                        }
                        if ((publishedDateElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublishedDate")) != null && publishedDateElement.getTextContent() != null && !publishedDateElement.getTextContent().isEmpty()) {
                            Calendar publishedDateInstance = DatatypeConverter.parseDateTime((String)publishedDateElement.getTextContent());
                            vMImageInstance.setPublishedDate(publishedDateInstance);
                        }
                        if ((showInGuiElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ShowInGui")) != null && showInGuiElement.getTextContent() != null && !showInGuiElement.getTextContent().isEmpty()) {
                            boolean showInGuiInstance = DatatypeConverter.parseBoolean((String)showInGuiElement.getTextContent().toLowerCase());
                            vMImageInstance.setShowInGui(showInGuiInstance);
                        }
                        if ((pricingDetailLinkElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PricingDetailLink")) == null) continue;
                        URI pricingDetailLinkInstance = new URI(pricingDetailLinkElement.getTextContent());
                        vMImageInstance.setPricingDetailLink(pricingDetailLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            VirtualMachineVMImageListResponse virtualMachineVMImageListResponse = result;
            return virtualMachineVMImageListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineVMImageReplicateResponse> replicateAsync(final String vmImageName, final VirtualMachineVMImageReplicateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineVMImageReplicateResponse>(){

            @Override
            public VirtualMachineVMImageReplicateResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.replicate(vmImageName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineVMImageReplicateResponse replicate(String vmImageName, VirtualMachineVMImageReplicateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (vmImageName == null) {
            throw new NullPointerException("vmImageName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getComputeImageAttributes() == null) {
            throw new NullPointerException("parameters.ComputeImageAttributes");
        }
        if (parameters.getComputeImageAttributes().getOffer() == null) {
            throw new NullPointerException("parameters.ComputeImageAttributes.Offer");
        }
        if (parameters.getComputeImageAttributes().getSku() == null) {
            throw new NullPointerException("parameters.ComputeImageAttributes.Sku");
        }
        if (parameters.getComputeImageAttributes().getVersion() == null) {
            throw new NullPointerException("parameters.ComputeImageAttributes.Version");
        }
        if (parameters.getMarketplaceImageAttributes() != null) {
            if (parameters.getMarketplaceImageAttributes().getPlan() == null) {
                throw new NullPointerException("parameters.MarketplaceImageAttributes.Plan");
            }
            if (parameters.getMarketplaceImageAttributes().getPlan().getName() == null) {
                throw new NullPointerException("parameters.MarketplaceImageAttributes.Plan.Name");
            }
            if (parameters.getMarketplaceImageAttributes().getPlan().getProduct() == null) {
                throw new NullPointerException("parameters.MarketplaceImageAttributes.Plan.Product");
            }
            if (parameters.getMarketplaceImageAttributes().getPlan().getPublisher() == null) {
                throw new NullPointerException("parameters.MarketplaceImageAttributes.Plan.Publisher");
            }
            if (parameters.getMarketplaceImageAttributes().getPublisherId() == null) {
                throw new NullPointerException("parameters.MarketplaceImageAttributes.PublisherId");
            }
        }
        if (parameters.getTargetLocations() == null) {
            throw new NullPointerException("parameters.TargetLocations");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vmImageName", vmImageName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"replicateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/vmimages/";
        url = url + URLEncoder.encode(vmImageName, "UTF-8");
        url = url + "/replicate";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element replicationInputElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ReplicationInput");
        requestDoc.appendChild(replicationInputElement);
        if (!(parameters.getTargetLocations() instanceof LazyCollection) || ((LazyCollection)parameters.getTargetLocations()).isInitialized()) {
            Element targetLocationsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TargetLocations");
            for (String targetLocationsItem : parameters.getTargetLocations()) {
                Element targetLocationsItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Region");
                targetLocationsItemElement.appendChild(requestDoc.createTextNode(targetLocationsItem));
                targetLocationsSequenceElement.appendChild(targetLocationsItemElement);
            }
            replicationInputElement.appendChild(targetLocationsSequenceElement);
        }
        Element computeImageAttributesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComputeImageAttributes");
        replicationInputElement.appendChild(computeImageAttributesElement);
        Element offerElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Offer");
        offerElement.appendChild(requestDoc.createTextNode(parameters.getComputeImageAttributes().getOffer()));
        computeImageAttributesElement.appendChild(offerElement);
        Element skuElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Sku");
        skuElement.appendChild(requestDoc.createTextNode(parameters.getComputeImageAttributes().getSku()));
        computeImageAttributesElement.appendChild(skuElement);
        Element versionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Version");
        versionElement.appendChild(requestDoc.createTextNode(parameters.getComputeImageAttributes().getVersion()));
        computeImageAttributesElement.appendChild(versionElement);
        if (parameters.getMarketplaceImageAttributes() != null) {
            Element marketplaceImageAttributesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MarketplaceImageAttributes");
            replicationInputElement.appendChild(marketplaceImageAttributesElement);
            Element publisherIdElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublisherId");
            publisherIdElement.appendChild(requestDoc.createTextNode(parameters.getMarketplaceImageAttributes().getPublisherId()));
            marketplaceImageAttributesElement.appendChild(publisherIdElement);
            Element planElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Plan");
            marketplaceImageAttributesElement.appendChild(planElement);
            Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
            nameElement.appendChild(requestDoc.createTextNode(parameters.getMarketplaceImageAttributes().getPlan().getName()));
            planElement.appendChild(nameElement);
            Element publisherElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Publisher");
            publisherElement.appendChild(requestDoc.createTextNode(parameters.getMarketplaceImageAttributes().getPlan().getPublisher()));
            planElement.appendChild(publisherElement);
            Element productElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Product");
            productElement.appendChild(requestDoc.createTextNode(parameters.getMarketplaceImageAttributes().getPlan().getProduct()));
            planElement.appendChild(productElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineVMImageReplicateResponse result = null;
            if (statusCode == 200) {
                Element stringElement;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineVMImageReplicateResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
                Element virtualMachineVMImageReplicateResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"", (String)"VirtualMachineVMImageReplicateResponse");
                if (virtualMachineVMImageReplicateResponseElement == null || (stringElement = XmlUtility.getElementByTagNameNS((Node)virtualMachineVMImageReplicateResponseElement, (String)"", (String)"string")) != null) {
                    // empty if block
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineVMImageReplicateResponse virtualMachineVMImageReplicateResponse = result;
            return virtualMachineVMImageReplicateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> shareAsync(final String vmImageName, final String permission) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.share(vmImageName, permission);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse share(String vmImageName, String permission) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("vmImageName", vmImageName);
            tracingParameters.put("permission", permission);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"shareAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachineVMImagesOperations().beginSharingAsync(vmImageName, permission).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> unreplicateAsync(final String vmImageName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.unreplicate(vmImageName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse unreplicate(String vmImageName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("vmImageName", vmImageName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"unreplicateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachineVMImagesOperations().beginUnreplicatingAsync(vmImageName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> updateAsync(final String imageName, final VirtualMachineVMImageUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.update(imageName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse update(String imageName, VirtualMachineVMImageUpdateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException {
        if (imageName == null) {
            throw new NullPointerException("imageName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("imageName", imageName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/vmimages/";
        url = url + URLEncoder.encode(imageName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element vMImageElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VMImage");
        requestDoc.appendChild(vMImageElement);
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
        vMImageElement.appendChild(labelElement);
        if (parameters.getOSDiskConfiguration() != null) {
            Element oSDiskConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OSDiskConfiguration");
            vMImageElement.appendChild(oSDiskConfigurationElement);
            if (parameters.getOSDiskConfiguration().getHostCaching() != null) {
                Element hostCachingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
                hostCachingElement.appendChild(requestDoc.createTextNode(parameters.getOSDiskConfiguration().getHostCaching()));
                oSDiskConfigurationElement.appendChild(hostCachingElement);
            }
        }
        if (parameters.getDataDiskConfigurations() != null && (!(parameters.getDataDiskConfigurations() instanceof LazyCollection) || ((LazyCollection)parameters.getDataDiskConfigurations()).isInitialized())) {
            Element dataDiskConfigurationsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataDiskConfigurations");
            for (DataDiskConfigurationUpdateParameters dataDiskConfigurationsItem : parameters.getDataDiskConfigurations()) {
                Element dataDiskConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataDiskConfiguration");
                dataDiskConfigurationsSequenceElement.appendChild(dataDiskConfigurationElement);
                if (dataDiskConfigurationsItem.getName() != null) {
                    Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    nameElement.appendChild(requestDoc.createTextNode(dataDiskConfigurationsItem.getName()));
                    dataDiskConfigurationElement.appendChild(nameElement);
                }
                if (dataDiskConfigurationsItem.getHostCaching() != null) {
                    Element hostCachingElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
                    hostCachingElement2.appendChild(requestDoc.createTextNode(dataDiskConfigurationsItem.getHostCaching()));
                    dataDiskConfigurationElement.appendChild(hostCachingElement2);
                }
                if (dataDiskConfigurationsItem.getLogicalUnitNumber() == null) continue;
                Element lunElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Lun");
                lunElement.appendChild(requestDoc.createTextNode(Integer.toString(dataDiskConfigurationsItem.getLogicalUnitNumber())));
                dataDiskConfigurationElement.appendChild(lunElement);
            }
            vMImageElement.appendChild(dataDiskConfigurationsSequenceElement);
        }
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            vMImageElement.appendChild(descriptionElement);
        }
        if (parameters.getLanguage() != null) {
            Element languageElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Language");
            languageElement.appendChild(requestDoc.createTextNode(parameters.getLanguage()));
            vMImageElement.appendChild(languageElement);
        }
        if (parameters.getImageFamily() != null) {
            Element imageFamilyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ImageFamily");
            imageFamilyElement.appendChild(requestDoc.createTextNode(parameters.getImageFamily()));
            vMImageElement.appendChild(imageFamilyElement);
        }
        if (parameters.getRecommendedVMSize() != null) {
            Element recommendedVMSizeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RecommendedVMSize");
            recommendedVMSizeElement.appendChild(requestDoc.createTextNode(parameters.getRecommendedVMSize()));
            vMImageElement.appendChild(recommendedVMSizeElement);
        }
        if (parameters.getEula() != null) {
            Element eulaElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Eula");
            eulaElement.appendChild(requestDoc.createTextNode(parameters.getEula()));
            vMImageElement.appendChild(eulaElement);
        }
        if (parameters.getIconUri() != null) {
            Element iconUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IconUri");
            iconUriElement.appendChild(requestDoc.createTextNode(parameters.getIconUri()));
            vMImageElement.appendChild(iconUriElement);
        }
        if (parameters.getSmallIconUri() != null) {
            Element smallIconUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SmallIconUri");
            smallIconUriElement.appendChild(requestDoc.createTextNode(parameters.getSmallIconUri()));
            vMImageElement.appendChild(smallIconUriElement);
        }
        if (parameters.getPrivacyUri() != null) {
            Element privacyUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PrivacyUri");
            privacyUriElement.appendChild(requestDoc.createTextNode(parameters.getPrivacyUri().toString()));
            vMImageElement.appendChild(privacyUriElement);
        }
        if (parameters.getPublishedDate() != null) {
            Element publishedDateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublishedDate");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            publishedDateElement.appendChild(requestDoc.createTextNode(simpleDateFormat.format(parameters.getPublishedDate().getTime())));
            vMImageElement.appendChild(publishedDateElement);
        }
        if (parameters.isShowInGui() != null) {
            Element showInGuiElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ShowInGui");
            showInGuiElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isShowInGui()).toLowerCase()));
            vMImageElement.appendChild(showInGuiElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

