/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchemaFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildSession.class})
public class PreferJavaRuntimeVariant {
    private final ImmutableAttributesSchema instance;

    @Inject
    public PreferJavaRuntimeVariant(NamedObjectInstantiator instantiator, ImmutableAttributesSchemaFactory schemaFactory) {
        this.instance = PreferJavaRuntimeVariant.create(instantiator, schemaFactory);
    }

    public ImmutableAttributesSchema getSchema() {
        return this.instance;
    }

    private static ImmutableAttributesSchema create(NamedObjectInstantiator instantiator, ImmutableAttributesSchemaFactory schemaFactory) {
        Usage runtimeUsage = (Usage)instantiator.named(Usage.class, "java-runtime");
        LibraryElements jarLibraryElements = (LibraryElements)instantiator.named(LibraryElements.class, "jar");
        PreferRuntimeVariantUsageDisambiguationRule usageDisambiguationRule = new PreferRuntimeVariantUsageDisambiguationRule(runtimeUsage);
        PreferJarVariantUsageDisambiguationRule formatDisambiguationRule = new PreferJarVariantUsageDisambiguationRule(jarLibraryElements);
        ImmutableMap strategies = ImmutableMap.of((Object)Usage.USAGE_ATTRIBUTE, new ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy(ImmutableList.of(), ImmutableList.of((Object)usageDisambiguationRule)), (Object)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, new ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy(ImmutableList.of(), ImmutableList.of((Object)formatDisambiguationRule)));
        return schemaFactory.create(strategies, ImmutableList.of((Object)Usage.USAGE_ATTRIBUTE, (Object)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE));
    }

    private static class PreferRuntimeVariantUsageDisambiguationRule
    implements Action<MultipleCandidatesDetails<Usage>> {
        private final Usage runtimeUsage;

        public PreferRuntimeVariantUsageDisambiguationRule(Usage runtimeUsage) {
            this.runtimeUsage = runtimeUsage;
        }

        public void execute(MultipleCandidatesDetails<Usage> details) {
            Set candidates;
            if (details.getConsumerValue() == null && (candidates = details.getCandidateValues()).contains(this.runtimeUsage)) {
                details.closestMatch((Object)this.runtimeUsage);
            }
        }
    }

    private static class PreferJarVariantUsageDisambiguationRule
    implements Action<MultipleCandidatesDetails<LibraryElements>> {
        private final LibraryElements jarLibraryElements;

        public PreferJarVariantUsageDisambiguationRule(LibraryElements jarLibraryElements) {
            this.jarLibraryElements = jarLibraryElements;
        }

        public void execute(MultipleCandidatesDetails<LibraryElements> details) {
            Set candidates;
            if (details.getConsumerValue() == null && (candidates = details.getCandidateValues()).contains(this.jarLibraryElements)) {
                details.closestMatch((Object)this.jarLibraryElements);
            }
        }
    }
}

