/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirMissingDependencyStorage;
import org.jetbrains.kotlin.fir.types.FirMissingDependencyStorageKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a7\u0010\u0000\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tR\u00020\u0002R\u00020\u0004j\u0006\u0010\u0003\u001a\u00020\u0002j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\n\u001aC\u0010\u0000\u001a\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u0001R\u00020\u0002R\u00020\u0004j\u0006\u0010\u0003\u001a\u00020\u0002j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"checkMissingDependencySuperTypes", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "classifierType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/KtSourceElement;)Z", "declaration", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "isEagerCheck", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/KtSourceElement;Z)Z", "checkers"})
public final class FirMissingDependencySupertypeUtilsKt {
    public static final boolean checkMissingDependencySuperTypes(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @Nullable ConeKotlinType classifierType, @Nullable KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ConeKotlinType coneKotlinType = classifierType;
        return FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes(context, reporter, (FirBasedSymbol)(coneKotlinType != null ? ToSymbolUtilsKt.toSymbol(coneKotlinType, context.getSession()) : null), source, false);
    }

    public static final boolean checkMissingDependencySuperTypes(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @Nullable FirBasedSymbol<?> declaration, @Nullable KtSourceElement source, boolean isEagerCheck) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration instanceof FirClassSymbol)) {
            return false;
        }
        Set<FirMissingDependencyStorage.TypeWithOrigin> missingSuperTypes = FirMissingDependencyStorageKt.getMissingDependencyStorage(context.getSession()).getMissingSuperTypes((FirClassSymbol)declaration);
        LanguageVersionSettings languageVersionSettings = context.getLanguageVersionSettings();
        for (FirMissingDependencyStorage.TypeWithOrigin typeWithOrigin : missingSuperTypes) {
            ConeKotlinType superType = typeWithOrigin.component1();
            FirMissingDependencyStorage.SupertypeOrigin origin = typeWithOrigin.component2();
            KtDiagnosticFactory2<ConeKotlinType, ConeKotlinType> diagnostic = origin == FirMissingDependencyStorage.SupertypeOrigin.TYPE_ARGUMENT && !languageVersionSettings.supportsFeature(LanguageFeature.ForbidUsingSupertypesWithInaccessibleContentInTypeArguments) ? FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS_IN_TYPE_ARGUMENT() : (isEagerCheck && !languageVersionSettings.supportsFeature(LanguageFeature.AllowEagerSupertypeAccessibilityChecks) ? FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS_WARNING() : FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS());
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), diagnostic, (Object)TypeUtilsKt.withNullability$default(TypeUtilsKt.withArguments(superType, new ConeTypeProjection[0]), false, TypeComponentsKt.getTypeContext(context.getSession()), null, false, 12, null), (Object)TypeConstructionUtilsKt.constructType$default((FirClassLikeSymbol)declaration, null, false, null, 7, null), null, (int)32, null);
        }
        return !((Collection)missingSuperTypes).isEmpty();
    }
}

