/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.smart;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTokenTypes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/yaml/smart/YAMLEmptySequenceItemBackspaceHandler;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "<init>", "()V", "shouldDelete", "", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "shouldDeleteSequenceMarker", "charDeleted", "intellij.yaml"})
public final class YAMLEmptySequenceItemBackspaceHandler
extends BackspaceHandlerDelegate {
    private boolean shouldDelete;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.shouldDelete = this.shouldDeleteSequenceMarker(c, file, editor);
    }

    private final boolean shouldDeleteSequenceMarker(char c, PsiFile file, Editor editor) {
        if (!CharsKt.isWhitespace((char)c)) {
            return false;
        }
        if (c != ' ') {
            return false;
        }
        if (!file.getLanguage().isKindOf((Language)YAMLLanguage.INSTANCE)) {
            return false;
        }
        int possibleSequenceItemMarkerOffset = editor.getCaretModel().getCurrentCaret().getOffset() - 2;
        if (possibleSequenceItemMarkerOffset < 0) {
            return false;
        }
        if (possibleSequenceItemMarkerOffset >= editor.getDocument().getTextLength()) {
            return false;
        }
        String string = editor.getDocument().getText(new TextRange(possibleSequenceItemMarkerOffset, possibleSequenceItemMarkerOffset + 1));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String possibleSequenceItemMarker = string;
        if (!Intrinsics.areEqual((Object)possibleSequenceItemMarker, (Object)"-")) {
            return false;
        }
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(possibleSequenceItemMarkerOffset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        return Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)((Object)YAMLTokenTypes.SEQUENCE_MARKER));
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!this.shouldDelete) {
            return false;
        }
        int sequenceItemMarkerOffset = editor.getCaretModel().getCurrentCaret().getOffset() - 1;
        if (sequenceItemMarkerOffset < 0) {
            return false;
        }
        if (sequenceItemMarkerOffset >= editor.getDocument().getTextLength()) {
            return false;
        }
        String string = editor.getDocument().getText(new TextRange(sequenceItemMarkerOffset, sequenceItemMarkerOffset + 1));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        if (!Intrinsics.areEqual((Object)text, (Object)"-")) {
            return false;
        }
        editor.getDocument().deleteString(sequenceItemMarkerOffset, sequenceItemMarkerOffset + 1);
        return true;
    }
}

