/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.ListStack;

public class DataPoint {
    private final List<VarType> localVariables;
    private final ListStack<VarType> stack;

    public DataPoint() {
        this(new ArrayList<VarType>(), new ListStack<VarType>());
    }

    private DataPoint(List<VarType> localVariables, ListStack<VarType> stack) {
        this.localVariables = localVariables;
        this.stack = stack;
    }

    public DataPoint copy() {
        return new DataPoint(new ArrayList<VarType>(this.localVariables), this.stack.copy());
    }

    public void setVariable(int index, VarType value) {
        if (index >= this.localVariables.size()) {
            for (int i = this.localVariables.size(); i <= index; ++i) {
                this.localVariables.add(new VarType(14));
            }
        }
        this.localVariables.set(index, value);
    }

    public VarType getVariable(int index) {
        if (index < this.localVariables.size()) {
            return this.localVariables.get(index);
        }
        return new VarType(14);
    }

    public static DataPoint getInitialDataPoint(StructMethod mt) {
        DataPoint point = new DataPoint();
        MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
        int k = 0;
        if (!mt.hasModifier(8)) {
            point.setVariable(k++, new VarType(8, 0, null));
        }
        for (int i = 0; i < md.params.length; ++i) {
            VarType var = md.params[i];
            point.setVariable(k++, var);
            if (var.getStackSize() != 2) continue;
            point.setVariable(k++, new VarType(12));
        }
        return point;
    }

    public ListStack<VarType> getStack() {
        return this.stack;
    }
}

