/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.VirtualFilePattern;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.toplevel.ClassContextFilter;
import org.jetbrains.plugins.groovy.dsl.toplevel.CompositeContextFilter;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.dsl.toplevel.FileContextFilter;
import org.jetbrains.plugins.groovy.dsl.toplevel.ScriptTypeFilter;
import org.jetbrains.plugins.groovy.dsl.toplevel.scopes.Scope;

public class Context {
    private final List<ContextFilter> myFilters = new ArrayList<ContextFilter>();

    public Context(Map args) {
        if (args == null) {
            return;
        }
        List extensions = (List)args.get("filetypes");
        if (extensions != null) {
            VirtualFilePattern vfilePattern = (extensions = ContainerUtil.map((Collection)extensions, x -> StringUtil.trimStart((String)x, (String)"."))).size() == 1 ? PlatformPatterns.virtualFile().withExtension((String)extensions.get(0)) : PlatformPatterns.virtualFile().withExtension(ArrayUtil.toStringArray((Collection)extensions));
            this.addFilter(new FileContextFilter((ElementPattern<? extends PsiFile>)PlatformPatterns.psiFile().withVirtualFile((ElementPattern)vfilePattern)));
        }
        if (args.containsKey("scriptType")) {
            this.addFilter(new ScriptTypeFilter((String)args.get("scriptType")));
        }
        if (args.containsKey("pathRegexp")) {
            this.addFilter(new FileContextFilter((ElementPattern<? extends PsiFile>)PlatformPatterns.psiFile().withVirtualFile((ElementPattern)PlatformPatterns.virtualFile().withPath((ElementPattern)StandardPatterns.string().matches((String)args.get("pathRegexp"))))));
        }
        if (args.get("scope") != null) {
            this.myFilters.addAll(((Scope)args.get("scope")).createFilters(args));
        }
        if (args.get("ctype") instanceof String) {
            this.addFilter(ClassContextFilter.subtypeOf((String)args.get("ctype")));
        } else if (args.get("ctype") instanceof ElementPattern) {
            this.addFilter(ClassContextFilter.fromClassPattern((ElementPattern)args.get("ctype")));
        }
    }

    private void addFilter(ContextFilter cl) {
        this.myFilters.add(cl);
    }

    @NotNull
    public ContextFilter getFilter() {
        if (this.myFilters.size() == 1) {
            ContextFilter contextFilter = this.myFilters.get(0);
            if (contextFilter == null) {
                Context.$$$reportNull$$$0(0);
            }
            return contextFilter;
        }
        ContextFilter contextFilter = CompositeContextFilter.compose(this.myFilters, true);
        if (contextFilter == null) {
            Context.$$$reportNull$$$0(1);
        }
        return contextFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/toplevel/Context", "getFilter"));
    }
}

